/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.sf.sfac.gui.editor.cmp.BaseObjectEditor;

public abstract class TreeObjectEditor
extends BaseObjectEditor {
    private Object editedObject;
    protected JPanel editionPane;
    protected JLabel titleLabel;
    private JTree theTree;
    private TreeModel treeModel = this.createTreeModel();
    private JScrollPane scroll;

    protected abstract String getTitle();

    protected abstract TreeModel createTreeModel();

    protected abstract void fireTreeDataChanged();

    public void edit(Object objToEdit) {
        this.editedObject = objToEdit;
        this.updateView();
    }

    public Object getEditedObject() {
        return this.editedObject;
    }

    public JComponent getTreeComponent() {
        if (this.scroll == null) {
            this.scroll = new JScrollPane(this.getTree());
        }
        return this.scroll;
    }

    public JTree getTree() {
        if (this.theTree == null) {
            this.theTree = this.createTree();
        }
        return this.theTree;
    }

    protected TreeModel getTreeModel() {
        return this.treeModel;
    }

    protected JTree createTree() {
        JTree tree = new JTree(this.treeModel);
        tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TreeObjectEditor.this.mouseDoubleClicked();
                }
            }
        });
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent newE) {
                TreeObjectEditor.this.treeSelectionChanged();
            }
        });
        this.synchronizeEditableState();
        this.updateView();
        return tree;
    }

    public JComponent getEditorComponent() {
        this.buildGUI();
        return this.editionPane;
    }

    public JLabel getLabelComponent() {
        return null;
    }

    public JComponent getObjectComponent() {
        return this.getEditorComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateView() {
        try {
            this.getEditorModificationSupport().setEnableEvents(false);
            if (this.titleLabel != null) {
                this.titleLabel.setText(this.getTitle());
            }
            this.fireTreeDataChanged();
        }
        finally {
            this.getEditorModificationSupport().setEnableEvents(true);
        }
    }

    public void updateModel() {
    }

    protected void buildGUI() {
        if (this.editionPane == null) {
            this.editionPane = new JPanel(new BorderLayout());
            this.editionPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.titleLabel = new JLabel();
            Font labelFont = this.titleLabel.getFont();
            this.titleLabel.setFont(labelFont.deriveFont(2.0f * labelFont.getSize2D()));
            this.editionPane.add((Component)this.titleLabel, "North");
            this.editionPane.add((Component)this.getTreeComponent(), "Center");
        }
    }

    protected void mouseDoubleClicked() {
    }

    protected void treeSelectionChanged() {
    }

    protected void synchronizeEditableState() {
        if (this.theTree != null) {
            boolean treeEnabled = this.isEditable() && this.isEnabled();
            this.theTree.setEnabled(treeEnabled);
            this.theTree.setBackground(treeEnabled ? Color.WHITE : Color.LIGHT_GRAY);
            this.theTree.setForeground(treeEnabled ? Color.BLACK : Color.DARK_GRAY);
            this.theTree.repaint();
        }
    }

    public TreePath getSelectedPath() {
        if (this.theTree != null) {
            return this.theTree.getSelectionPath();
        }
        return null;
    }

    public Object getSelectedObject() {
        Object selected = null;
        if (this.theTree != null) {
            TreePath selectionPath = this.theTree.getSelectionPath();
            selected = selectionPath == null ? null : selectionPath.getLastPathComponent();
        }
        return selected;
    }

    public void clearSelection() {
        if (this.theTree != null) {
            this.theTree.clearSelection();
        }
    }

    public void selectDefaultItem() {
    }
}

