/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import javax.swing.table.AbstractTableModel;
import net.sf.sfac.gui.editor.ModelAccess;
import net.sf.sfac.gui.editor.access.IndexedModelAccess;
import net.sf.sfac.gui.editor.cmp.BaseObjectEditor;
import net.sf.sfac.utils.Comparison;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableObjectModel
extends AbstractTableModel {
    private BaseObjectEditor editor;
    private IndexedModelAccess indexedAccess;
    private Boolean sorted;
    private boolean editable;

    public TableObjectModel() {
    }

    public TableObjectModel(boolean isModelSorted) {
        this.sorted = isModelSorted;
    }

    public TableObjectModel(BaseObjectEditor newEditor) {
        this.setEditor(newEditor);
    }

    public Class<?> getItemClass() {
        return this.getIndexedAccess().getModelClass();
    }

    public void setEditor(BaseObjectEditor newEditor) {
        if (this.editor != null) {
            this.removeTableModelListener(this.editor.getEditorModificationSupport().getListenerForTableModel());
        }
        this.editor = newEditor;
        this.indexedAccess = null;
        if (this.editor != null) {
            this.addTableModelListener(this.editor.getEditorModificationSupport().getListenerForTableModel());
        }
    }

    private boolean isSorted() {
        if (this.sorted != null) {
            return this.sorted;
        }
        return !this.canSwitchItems();
    }

    protected IndexedModelAccess getIndexedAccess() {
        if (this.indexedAccess == null) {
            ModelAccess access = this.editor.getModelAccess();
            this.indexedAccess = access instanceof IndexedModelAccess ? (IndexedModelAccess)access : new IndexedModelAccess(access);
        }
        return this.indexedAccess;
    }

    public Object getObjectAt(int index) {
        return this.getIndexedAccess().getItem(this.editor.getEditedObject(), index);
    }

    public boolean canSetItem() {
        return this.getIndexedAccess().canSetItem();
    }

    public void setObjectAt(int index, Object newObject) {
        Object editedObject = this.editor.getEditedObject();
        Object currentValue = this.getIndexedAccess().getItem(editedObject, index);
        if (newObject != currentValue) {
            this.getIndexedAccess().setItem(editedObject, index, newObject);
            if (this.isSorted()) {
                this.fireTableDataChanged();
            } else {
                this.fireTableRowsUpdated(index, index);
            }
        }
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int column) {
        return this.editor.getTranslatedLabel();
    }

    @Override
    public int getRowCount() {
        return this.getIndexedAccess().getItemCount(this.editor.getEditedObject());
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getObjectAt(rowIndex);
    }

    @Override
    public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
        this.setObjectAt(rowIndex, newValue);
    }

    public boolean canAddItem() {
        return this.getIndexedAccess().canAddItem();
    }

    public void addItem(int index) {
        this.getIndexedAccess().addItem(this.editor.getEditedObject(), index, null);
        if (this.isSorted()) {
            this.fireTableDataChanged();
        } else {
            this.fireTableRowsInserted(index, index);
        }
    }

    public boolean canRemoveItem() {
        return this.getIndexedAccess().canRemoveItem();
    }

    public void removeItem(int index) {
        this.getIndexedAccess().removeItem(this.editor.getEditedObject(), index);
        this.fireTableRowsDeleted(index, index);
    }

    public boolean canSwitchItems() {
        return this.getIndexedAccess().canSwitchItem();
    }

    public void switchItems(int index1, int index2) {
        this.getIndexedAccess().switchItems(this.editor.getEditedObject(), index1, index2);
        this.fireTableRowsUpdated(index1, index2);
    }

    public int indexOf(Object obj) {
        int len = this.getRowCount();
        for (int i = 0; i < len; ++i) {
            if (!Comparison.equals((Object)obj, (Object)this.getObjectAt(i))) continue;
            return i;
        }
        return -1;
    }

    public void setEditable(boolean newEditable) {
        this.editable = newEditable;
    }

    @Override
    public boolean isCellEditable(int newRowIndex, int newColumnIndex) {
        return this.editable && this.canSetItem();
    }
}

