/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.sf.sfac.gui.editor.EditorContext;
import net.sf.sfac.gui.editor.cmp.SimpleObjectEditor;
import net.sf.sfac.gui.editor.cmp.TableObjectModel;
import net.sf.sfac.gui.framework.ActionRepository;
import net.sf.sfac.gui.framework.SharedResources;
import net.sf.sfac.gui.utils.ObjectSelectionListener;
import net.sf.sfac.gui.utils.ObjectSelector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableObjectEditor
extends SimpleObjectEditor
implements ObjectSelector {
    private static final Log log = LogFactory.getLog(TableObjectEditor.class);
    private TableObjectModel tableModel;
    private List<ObjectSelectionListener> listeners;
    private JPanel objectPane;
    private JTable table;
    private JScrollPane scroll;
    private JToolBar toolbar;
    private ActionRepository repo;
    private Action viewAction;
    private Action addAction;
    private Action createAndAddAction;
    private Action removeAction;
    private Action moveUpAction;
    private Action moveDownAction;

    public TableObjectEditor() {
        this.setDefaultProperties();
    }

    public TableObjectEditor(TableObjectModel externalTableModel) {
        this.tableModel = externalTableModel;
        this.tableModel.setEditor(this);
        this.setDefaultProperties();
    }

    private void setDefaultProperties() {
        this.setProperty("weightx", 1.0);
        this.setProperty("weighty", 1.0);
        this.setProperty("fill", 1);
    }

    protected TableObjectModel createTableModel() {
        return new TableObjectModel(this);
    }

    protected TableObjectModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = this.createTableModel();
        }
        return this.tableModel;
    }

    public JComponent getTableComponent() {
        if (this.scroll == null) {
            this.scroll = new JScrollPane(this.getTable());
        }
        return this.scroll;
    }

    public JTable getTable() {
        if (this.table == null) {
            this.table = this.createTable();
            this.configureTable(this.table);
            this.synchronizeEditableState();
        }
        return this.table;
    }

    protected JTable createTable() {
        return new JTable(this.getTableModel());
    }

    protected void configureTable(JTable createdTable) {
        createdTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && TableObjectEditor.this.canViewItem() && !TableObjectEditor.this.isEditable()) {
                    TableObjectEditor.this.viewSelectedItem();
                }
            }
        });
        createdTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TableObjectEditor.this.checkActionStates();
                TableObjectEditor.this.fireObjectSelectionChanged();
            }
        });
        createdTable.setSelectionMode(0);
        TableColumnModel columnModel = createdTable.getColumnModel();
        int nbrColumn = columnModel.getColumnCount();
        for (int i = 0; i < nbrColumn; ++i) {
            TableCellEditor editor;
            TableCellRenderer renderer = this.getColumnRenderer(i);
            if (renderer != null) {
                columnModel.getColumn(i).setCellRenderer(renderer);
            }
            if ((editor = this.getColumnEditor(i)) == null) continue;
            columnModel.getColumn(i).setCellEditor(editor);
        }
    }

    void checkActionStates() {
        boolean selected;
        boolean enabled = this.getEditedObject() != null && this.isEditable() && this.isEnabled();
        int selectedIndex = this.getSelectedIndex();
        boolean bl = selected = selectedIndex >= 0;
        if (this.viewAction != null) {
            this.viewAction.setEnabled(selected);
        }
        if (this.addAction != null) {
            this.addAction.setEnabled(this.canAddItem() && enabled);
        }
        if (this.createAndAddAction != null) {
            this.createAndAddAction.setEnabled(this.canCreateAndAddItem() && enabled);
        }
        if (this.removeAction != null) {
            this.removeAction.setEnabled(this.canRemoveItem() && enabled && selected);
        }
        if (this.moveUpAction != null) {
            this.moveUpAction.setEnabled(this.canSwitchItems() && enabled && selected && selectedIndex > 0);
            this.moveDownAction.setEnabled(this.canSwitchItems() && enabled && selected && selectedIndex < this.getTableModel().getRowCount() - 1);
        }
    }

    protected int getSelectedIndex() {
        int selectedIndex;
        int n = selectedIndex = this.table == null ? -1 : this.table.getSelectedRow();
        if (selectedIndex >= this.getTableModel().getRowCount()) {
            selectedIndex = -1;
        }
        return selectedIndex;
    }

    @Override
    public JComponent getObjectComponent() {
        if (this.objectPane == null) {
            this.objectPane = new JPanel(new GridBagLayout());
            if (this.canViewItem() || this.canAddItem() || this.canSwitchItems()) {
                this.objectPane.add((Component)this.getToolBar(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 4, 0), 0, 0));
            }
            this.objectPane.add((Component)this.getTableComponent(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.synchronizeEditableState();
            this.updateView();
        }
        return this.objectPane;
    }

    protected JToolBar getToolBar() {
        if (this.toolbar == null) {
            this.repo = new ActionRepository();
            this.createActions(this.repo);
            this.toolbar = this.repo.createToolBar();
        }
        return this.toolbar;
    }

    @Override
    public void updateModel() {
        this.stopAllEditing();
    }

    void stopAllEditing() {
        if (this.table != null && this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
    }

    void cancelAllEditing() {
        if (this.table != null && this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateView() {
        try {
            this.getEditorModificationSupport().setEnableEvents(false);
            this.stopAllEditing();
            this.getTableModel().fireTableDataChanged();
            this.checkActionStates();
        }
        finally {
            this.getEditorModificationSupport().setEnableEvents(true);
        }
    }

    protected void viewSelectedItem() {
        Object selected = this.getSelectedObject();
        if (selected != null) {
            this.getEditorContext().editInContext(selected, selected.getClass(), this);
        }
    }

    @Override
    protected void synchronizeEditableState() {
        if (this.table != null) {
            boolean tableEnabled = this.isEnabled();
            this.table.setEnabled(tableEnabled);
            this.table.setBackground(tableEnabled ? Color.WHITE : Color.LIGHT_GRAY);
            this.table.setForeground(tableEnabled ? Color.BLACK : Color.DARK_GRAY);
            this.table.repaint();
            this.getTableModel().setEditable(this.isEditable());
        }
        this.checkActionStates();
    }

    private void createActions(ActionRepository repos) {
        if (this.canViewItem()) {
            this.viewAction = repos.addAction("viewItem", "View", "View selected item", null, null, "a0", SharedResources.getIcon("view.png"), new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    TableObjectEditor.this.viewSelectedItem();
                }
            });
        }
        if (this.canAddItem()) {
            this.addAction = repos.addAction("addItem", "Add", "Add a new item", null, null, "a1", SharedResources.getIcon("addItem.png"), new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    TableObjectEditor.this.addItem();
                }
            });
        }
        if (this.canCreateAndAddItem()) {
            this.createAndAddAction = repos.addAction("createAndAddItem", "Create and add", "Create, edit and add a new item", null, null, "a2", SharedResources.getIcon("newItem.png"), new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    TableObjectEditor.this.createAndAddItem();
                }
            });
        }
        if (this.canRemoveItem()) {
            this.removeAction = repos.addAction("removeItem", "Remove", "Remove selected item", null, null, "a3", SharedResources.getIcon("removeItem.gif"), new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    TableObjectEditor.this.removeItem();
                }
            });
        }
        if (this.canSwitchItems()) {
            this.moveUpAction = repos.addAction("moveUp", "Move up", "Move selected item up", null, null, "a4", SharedResources.getIcon("moveUp.png"), new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    TableObjectEditor.this.moveItem(-1);
                }
            });
            this.moveDownAction = repos.addAction("moveDown", "Move down", "Move selected item down", null, null, "a5", SharedResources.getIcon("moveDown.png"), new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    TableObjectEditor.this.moveItem(1);
                }
            });
        }
    }

    protected boolean canViewItem() {
        EditorContext edContext = this.getEditorContext();
        return edContext != null && edContext.canEditInContext(false, this.getTableModel().getItemClass(), this);
    }

    protected boolean canAddItem() {
        return this.getTableModel().canAddItem() && this.getTableModel().canSetItem();
    }

    protected boolean canCreateAndAddItem() {
        return this.canAddItem();
    }

    protected boolean canRemoveItem() {
        return this.getTableModel().canRemoveItem() && this.canAddItem();
    }

    protected boolean canSwitchItems() {
        return this.getTableModel().canSwitchItems();
    }

    protected void createAndAddItem() {
        if (this.getTableModel().canAddItem()) {
            int selectedIndex = this.getSelectedIndex();
            if (selectedIndex < 0 || selectedIndex > this.getTableModel().getRowCount()) {
                selectedIndex = this.getTableModel().getRowCount();
            }
            log.info((Object)("Create and add a new item at index " + selectedIndex));
            this.getTableModel().addItem(selectedIndex);
            Object addedItem = this.getEditorContext().editInContext(null, this.getTableModel().getItemClass(), this);
            log.debug((Object)("Selected item to add = " + addedItem));
            this.getTableModel().setObjectAt(selectedIndex, addedItem);
        }
    }

    protected void addItem() {
        if (this.canAddItem()) {
            int selectedIndex = this.getSelectedIndex();
            if (selectedIndex < 0 || selectedIndex > this.getTableModel().getRowCount()) {
                selectedIndex = this.getTableModel().getRowCount();
            }
            log.info((Object)("Add a new item at index " + selectedIndex));
            this.getTableModel().addItem(selectedIndex);
        }
    }

    protected void moveItem(int movment) {
        if (this.canSwitchItems()) {
            int selectedIndex = this.getSelectedIndex();
            int targetIndex = selectedIndex + movment;
            int rowCount = this.getTableModel().getRowCount();
            if (selectedIndex >= 0 && targetIndex >= 0 && selectedIndex < rowCount && targetIndex < rowCount) {
                this.getTableModel().switchItems(selectedIndex, targetIndex);
                this.table.setRowSelectionInterval(targetIndex, targetIndex);
            }
        }
    }

    protected void removeItem() {
        if (this.canRemoveItem()) {
            this.cancelAllEditing();
            int selectedIndex = this.getSelectedIndex();
            if (selectedIndex >= 0 && selectedIndex < this.getTableModel().getRowCount()) {
                this.getTableModel().removeItem(selectedIndex);
            }
        }
    }

    protected TableCellRenderer getColumnRenderer(int columnIndex) {
        return null;
    }

    protected TableCellEditor getColumnEditor(int columnIndex) {
        return null;
    }

    @Override
    protected Object getViewValue() {
        return null;
    }

    @Override
    protected boolean isViewReady() {
        return this.table != null;
    }

    @Override
    protected void setViewValue(Object newViewValue) {
    }

    @Override
    public void addObjectSelectionListener(ObjectSelectionListener lis) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ObjectSelectionListener>();
        }
        this.listeners.add(lis);
    }

    @Override
    public void clearSelection() {
        if (this.table != null) {
            this.table.clearSelection();
        }
    }

    @Override
    public Object getSelectedObject() {
        int row;
        int n = row = this.table == null ? -1 : this.table.getSelectedRow();
        if (row < 0 || row >= this.getTableModel().getRowCount()) {
            return null;
        }
        return this.getTableModel().getObjectAt(row);
    }

    @Override
    public int getSelectedObjectCount() {
        return this.table == null ? 0 : this.table.getSelectedRowCount();
    }

    public List<Object> getSelectedObjects() {
        int[] row;
        int[] nArray = row = this.table == null ? null : this.table.getSelectedRows();
        if (row == null) {
            return null;
        }
        int len = row.length;
        if (len == 0) {
            return null;
        }
        ArrayList<Object> selection = new ArrayList<Object>(len + 2);
        for (int i = 0; i < len; ++i) {
            selection.add(this.getTableModel().getObjectAt(row[i]));
        }
        return selection;
    }

    @Override
    public boolean isMultiSelectionEnabled() {
        return true;
    }

    @Override
    public boolean canSelectObjects(List<?> toSelect) {
        Object newSelection = null;
        if (toSelect != null && toSelect.size() == 1) {
            newSelection = toSelect.get(0);
        }
        return newSelection == null || this.getTableModel().indexOf(newSelection) >= 0;
    }

    @Override
    public void selectObjects(List<?> toSelect) {
        Object newSelection = null;
        if (toSelect != null && toSelect.size() == 1) {
            newSelection = toSelect.get(0);
        }
        if (this.table != null) {
            if (newSelection == null) {
                this.table.clearSelection();
            } else {
                int selectedIndex = this.getTableModel().indexOf(newSelection);
                this.table.setRowSelectionInterval(selectedIndex, selectedIndex);
            }
        }
    }

    @Override
    public void removeObjectSelectionListener(ObjectSelectionListener lis) {
        if (this.listeners != null) {
            this.listeners.remove(lis);
        }
    }

    @Override
    public void selectDefaultItem() {
        if (this.table != null && this.getTableModel().getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    protected void fireObjectSelectionChanged() {
        if (this.listeners != null) {
            for (ObjectSelectionListener lis : this.listeners) {
                lis.objectSelectionChanged(this);
            }
        }
    }
}

