/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import net.sf.sfac.gui.editor.cmp.SimpleObjectEditor;
import net.sf.sfac.utils.Comparison;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringEditor
extends SimpleObjectEditor {
    private static Log log = LogFactory.getLog(StringEditor.class);
    private boolean multiline;
    private JTextComponent textField;
    private JComponent component;

    public StringEditor() {
    }

    public StringEditor(boolean isMultilineText) {
        this.setMultiline(isMultilineText);
    }

    public void setMultiline(boolean multilineText) {
        this.multiline = multilineText;
        this.setProperty("weightx", multilineText ? 0.2 : 0.0);
        this.setProperty("fill", multilineText ? 1 : 2);
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public JComponent getObjectComponent() {
        if (this.component == null) {
            if (this.multiline) {
                JTextArea area = new JTextArea(5, 15);
                area.setLineWrap(true);
                area.setWrapStyleWord(true);
                this.textField = area;
                this.component = new JScrollPane(this.textField);
            } else {
                this.textField = new JTextField(15);
                this.component = this.textField;
            }
            this.component.setMinimumSize(this.component.getPreferredSize());
            this.registerFocusListener(this.textField);
            this.synchronizeEditableState();
            this.updateView();
            this.textField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent newE) {
                    StringEditor.this.checkModified();
                }

                public void insertUpdate(DocumentEvent newE) {
                    StringEditor.this.checkModified();
                }

                public void removeUpdate(DocumentEvent newE) {
                    StringEditor.this.checkModified();
                }
            });
        }
        return this.component;
    }

    void checkModified() {
        if (this.getEditorModificationSupport().getEnableEvents() && this.isEditable()) {
            this.updateModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateView() {
        try {
            JScrollPane scroll;
            JScrollBar vertScroll;
            this.getEditorModificationSupport().setEnableEvents(false);
            super.updateView();
            if (this.multiline && this.component != null && (vertScroll = (scroll = (JScrollPane)this.component).getVerticalScrollBar()) != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        vertScroll.getModel().setValue(0);
                    }
                });
            }
        }
        finally {
            this.getEditorModificationSupport().setEnableEvents(true);
        }
    }

    protected void synchronizeEditableState() {
        if (this.textField != null) {
            this.textField.setEditable(this.isEditable());
            this.textField.setEnabled(this.isEnabled());
            if (this.multiline) {
                this.textField.setBackground(this.isEditable() ? Color.WHITE : Color.LIGHT_GRAY);
            }
        }
    }

    protected boolean isViewReady() {
        return this.textField != null;
    }

    protected Object getViewValue() {
        String text = this.textField.getText();
        if (text != null) {
            text = text.trim();
        }
        return text;
    }

    protected void setViewValue(Object modelValue) {
        final String modelText = (String)modelValue;
        String viewText = (String)this.getViewValue();
        if (!Comparison.equals((Object)modelText, (Object)viewText)) {
            try {
                this.textField.setText(modelText);
            }
            catch (IllegalStateException ise) {
                log.warn((Object)("Unable to update textFiled '" + this.getModelAccess().getFieldPath() + "' with value " + viewText + " --> " + modelText), (Throwable)ise);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        StringEditor.this.setViewValue(modelText);
                    }
                });
            }
        }
    }

    public void setProperty(String name, Object value) {
        if (name.equals("type")) {
            this.setMultiline(value != null && value.equals("text"));
        } else {
            super.setProperty(name, value);
        }
    }

    public Object getProperty(String name, Object defaultValue) {
        if (name.equals("type")) {
            return this.multiline ? "text" : "line";
        }
        return super.getProperty(name, defaultValue);
    }

    protected boolean valueHasChanged(Object oldValue, Object newValue) {
        return !Comparison.stringEquals((Object)oldValue, (Object)newValue);
    }
}

