/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.sfac.gui.editor.cmp.BaseObjectEditor;
import net.sf.sfac.utils.Comparison;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SimpleObjectEditor
extends BaseObjectEditor {
    private static Log log = LogFactory.getLog(SimpleObjectEditor.class);
    private static final int DEFAULT_HEIGHT = new JTextField((String)"A").getPreferredSize().height;
    private JComponent editorCmp;
    private FocusListener theFocusListener;

    public JComponent getEditorComponent() {
        if (this.editorCmp == null) {
            JComponent theLabel = this.getLabelComponent();
            if (theLabel == null) {
                this.editorCmp = this.getObjectComponent();
            } else {
                this.editorCmp = new JPanel();
                this.editorCmp.add(theLabel);
                JComponent objectEditor = this.getObjectComponent();
                this.editorCmp.add(objectEditor);
            }
        }
        return this.editorCmp;
    }

    public static void adjustSize(JComponent cmp) {
        Dimension dim = cmp.getPreferredSize();
        if (dim.height != DEFAULT_HEIGHT) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Ajust height from " + dim.height + " to " + DEFAULT_HEIGHT + " for " + cmp));
            }
            Dimension newDim = new Dimension(dim.width, DEFAULT_HEIGHT);
            cmp.setPreferredSize(newDim);
            cmp.setMinimumSize(newDim);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateView() {
        try {
            this.getEditorModificationSupport().setEnableEvents(false);
            this.updateLabelText();
            this.updateDescriptionText();
            if (this.isViewReady()) {
                this.setViewValue(this.getModelValue());
            }
        }
        finally {
            this.getEditorModificationSupport().setEnableEvents(true);
        }
    }

    public void updateModel() {
        Object viewValue;
        Object modelValue;
        if (this.isEditable() && this.isEnabled() && this.isViewReady() && this.valueHasChanged(modelValue = this.getModelValue(), viewValue = this.getViewValue())) {
            this.setModelValue(viewValue);
            this.getEditorModificationSupport().fireEditorModified(modelValue);
            this.updateView();
        }
    }

    protected boolean valueHasChanged(Object oldValue, Object newValue) {
        return !Comparison.equals((Object)oldValue, (Object)newValue);
    }

    protected abstract boolean isViewReady();

    protected abstract Object getViewValue();

    protected abstract void setViewValue(Object var1);

    protected void registerFocusListener(Component cmp) {
        if (this.theFocusListener == null) {
            this.theFocusListener = new FocusListener(){

                public void focusLost(FocusEvent newE) {
                    SimpleObjectEditor.this.updateModel();
                }

                public void focusGained(FocusEvent newE) {
                }
            };
        }
        cmp.addFocusListener(this.theFocusListener);
        if (cmp instanceof Container) {
            Container containr = (Container)cmp;
            int len = containr.getComponentCount();
            for (int i = 0; i < len; ++i) {
                this.registerFocusListener(containr.getComponent(i));
            }
        }
    }
}

