/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import net.sf.sfac.gui.editor.EditorContext;
import net.sf.sfac.gui.editor.EditorFactory;
import net.sf.sfac.gui.editor.ModelAccess;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.gui.editor.access.IndexedModelAccess;
import net.sf.sfac.gui.editor.cmp.BaseObjectEditor;
import net.sf.sfac.gui.editor.cmp.ListObjectEditor;
import net.sf.sfac.gui.editor.cmp.MultiObjectEditor;
import net.sf.sfac.gui.utils.ObjectSelectionListener;
import net.sf.sfac.gui.utils.ObjectSelector;
import net.sf.sfac.setting.Settings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetAndDetailsEditor
extends BaseObjectEditor
implements EditorContext,
ObjectSelectionListener {
    private static Log log = LogFactory.getLog(SetAndDetailsEditor.class);
    private static final String LIST_DIVIDER_LOCATION_KEY = "ui.setAndDetailsSplitPane.dividerLocation";
    private String title;
    private Object currentItem;
    private MultiObjectEditor detailsEditor = new MultiObjectEditor();
    private int nbrLists;
    private ObjectEditor[] selectors;
    private ObjectSelector currentSelector;
    private JPanel editorPane;
    private JSplitPane splitPane;
    private JLabel titleLabel;

    public SetAndDetailsEditor() {
        this(new ObjectEditor[0]);
    }

    public SetAndDetailsEditor(ObjectEditor ... selectionLists) {
        this.detailsEditor.addEditorModificationListener(this.getEditorModificationSupport().getListenerForSubEditors());
        this.registerSelectors(selectionLists);
        this.setDefaultProperties();
    }

    public void registerSelectors(ObjectEditor ... selectionLists) {
        if (this.nbrLists > 0) {
            throw new IllegalStateException("The ObjectEditor to be used for selection cannot be changed");
        }
        this.selectors = selectionLists;
        this.nbrLists = this.selectors == null ? 0 : this.selectors.length;
        for (int i = 0; i < this.nbrLists; ++i) {
            try {
                ((ObjectSelector)((Object)this.selectors[i])).addObjectSelectionListener(this);
                continue;
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("The selectionList editor " + this.selectors[i].getClass().getName() + " must implement the ObjectSelector interface", cce);
            }
        }
    }

    private void setDefaultProperties() {
        this.setProperty("weightx", 1.0);
        this.setProperty("weighty", 1.0);
        this.setProperty("fill", 1);
    }

    @Override
    public void edit(Object objToEdit) {
        if (this.nbrLists == 0) {
            throw new IllegalArgumentException("You must define at least one selectionLists");
        }
        super.edit(objToEdit);
        for (int i = 0; i < this.nbrLists; ++i) {
            this.selectors[i].edit(objToEdit);
        }
        this.updateView();
        ((ObjectSelector)((Object)this.selectors[0])).selectDefaultItem();
    }

    @Override
    public JComponent getEditorComponent() {
        if (this.editorPane == null) {
            if (this.nbrLists == 0) {
                throw new IllegalArgumentException("You must define at least one selectionLists");
            }
            this.editorPane = new JPanel(new BorderLayout());
            this.editorPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.titleLabel = new JLabel();
            Font labelFont = this.titleLabel.getFont();
            this.titleLabel.setFont(labelFont.deriveFont(2.0f * labelFont.getSize2D()));
            this.editorPane.add((Component)this.titleLabel, "North");
            JPanel listPane = new JPanel(new GridBagLayout());
            for (int i = 0; i < this.nbrLists; ++i) {
                int top = i == 0 ? 0 : 5;
                listPane.add((Component)this.selectors[i].getEditorComponent(), new GridBagConstraints(0, i, 1, 1, 1.0, 1.0, 10, 1, new Insets(top, 0, 0, 0), 0, 0));
            }
            JComponent detailsPane = this.detailsEditor.getEditorComponent();
            this.splitPane = new JSplitPane(1, listPane, detailsPane);
            Settings sett = this.getSettings();
            int dividerLocation = sett == null ? 200 : sett.getIntProperty(LIST_DIVIDER_LOCATION_KEY, 200);
            this.splitPane.setDividerLocation(dividerLocation);
            this.splitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    SetAndDetailsEditor.this.storeSplitPanelDividerLocation();
                }
            });
            this.editorPane.add((Component)this.splitPane, "Center");
            ((ObjectSelector)((Object)this.selectors[0])).selectDefaultItem();
            this.synchronizeEditableState();
        }
        return this.editorPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateView() {
        try {
            this.getEditorModificationSupport().setEnableEvents(false);
            if (this.editorPane != null) {
                this.titleLabel.setText(this.title);
            }
            for (int i = 0; i < this.nbrLists; ++i) {
                this.selectors[i].updateView();
            }
            if (this.detailsEditor != null) {
                this.detailsEditor.updateView();
            }
        }
        finally {
            this.getEditorModificationSupport().setEnableEvents(true);
        }
    }

    @Override
    public void updateModel() {
        for (int i = 0; i < this.nbrLists; ++i) {
            this.selectors[i].updateModel();
        }
        if (this.detailsEditor != null) {
            this.detailsEditor.updateModel();
        }
    }

    void storeSplitPanelDividerLocation() {
        Settings setts = this.getSettings();
        if (setts != null) {
            setts.setIntProperty(LIST_DIVIDER_LOCATION_KEY, this.splitPane.getDividerLocation());
        }
    }

    @Override
    public void setModelAccess(ModelAccess newModelAccess) {
        System.out.println("Model acces is: " + newModelAccess);
        super.setModelAccess(newModelAccess);
        if (this.nbrLists == 0) {
            if (newModelAccess instanceof IndexedModelAccess) {
                log.info((Object)("Create default ListObjectEditor as selector for " + this));
                ListObjectEditor selector = new ListObjectEditor();
                selector.setEditorContext(this);
                selector.setModelAccess(newModelAccess);
                this.registerSelectors(selector);
            } else {
                throw new IllegalArgumentException("You must define at least one selectionLists");
            }
        }
    }

    protected void setSelectedObject(Object selected, ObjectSelector source) {
        log.debug((Object)("Object " + selected + " selection from " + source + " (previously " + this.currentItem + " from " + this.currentSelector + ")"));
        if (this.currentItem != selected && (selected != null || this.currentSelector == source)) {
            if (this.detailsEditor != null) {
                this.detailsEditor.updateModel();
                this.currentItem = selected;
                this.currentSelector = source;
                this.detailsEditor.edit(this.currentItem);
            }
            for (int i = 0; i < this.nbrLists; ++i) {
                if (this.selectors[i] == source) continue;
                ((ObjectSelector)((Object)this.selectors[i])).clearSelection();
            }
        } else {
            log.warn((Object)" --> selection ignored");
        }
    }

    public Object getEditedSubObject() {
        return this.currentItem;
    }

    @Override
    public void setEditorContext(EditorContext newContext) {
        super.setEditorContext(newContext);
        for (int i = 0; i < this.nbrLists; ++i) {
            this.selectors[i].setEditorContext(this);
        }
        if (this.detailsEditor != null) {
            this.detailsEditor.setEditorContext(this);
        }
    }

    @Override
    protected void synchronizeEditableState() {
        boolean editable = this.isEditable();
        boolean enabled = this.isEnabled();
        this.detailsEditor.setEditable(editable);
        this.detailsEditor.setEnabled(enabled);
        for (int i = 0; i < this.nbrLists; ++i) {
            this.selectors[i].setEditable(editable);
            this.selectors[i].setEnabled(enabled);
        }
    }

    @Override
    public JComponent getObjectComponent() {
        return this.getEditorComponent();
    }

    @Override
    public boolean canEditInContext(boolean create, Class<?> objectClass, ObjectEditor source) {
        return false;
    }

    @Override
    public <T> T editInContext(T obj, Class<T> objectClass, ObjectEditor source) {
        this.edit(obj);
        return null;
    }

    @Override
    public Object getContextObject(String objectKey) {
        return this.getEditorContext().getContextObject(objectKey);
    }

    @Override
    public EditorFactory getEditorFactory() {
        return this.getEditorContext().getEditorFactory();
    }

    @Override
    public Collection<ObjectEditor> getEditors() {
        return Collections.singleton(this.detailsEditor);
    }

    @Override
    public void objectSelectionChanged(ObjectSelector source) {
        this.setSelectedObject(source.getSelectedObject(), source);
    }
}

