/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import java.lang.reflect.Constructor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import net.sf.sfac.gui.editor.ModelAccess;
import net.sf.sfac.gui.editor.cmp.SimpleObjectEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NumberEditor
extends SimpleObjectEditor {
    private static Log log = LogFactory.getLog(NumberEditor.class);
    private Class<?> modelClass;
    private Constructor<?> stringBasedConstructor;
    private boolean isPrimitive;
    private JTextField component;

    public NumberEditor() {
        this.setProperty("fill", 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setModelAccess(ModelAccess newModelAccess) {
        super.setModelAccess(newModelAccess);
        Class<?> accessModelClass = newModelAccess.getModelClass();
        this.isPrimitive = accessModelClass.isPrimitive();
        if (this.isPrimitive) {
            if (accessModelClass == Integer.TYPE) {
                this.modelClass = Integer.class;
            } else if (accessModelClass == Long.TYPE) {
                this.modelClass = Long.class;
            } else if (accessModelClass == Double.TYPE) {
                this.modelClass = Double.class;
            } else if (accessModelClass == Float.TYPE) {
                this.modelClass = Float.class;
            } else if (accessModelClass == Byte.TYPE) {
                this.modelClass = Byte.class;
            } else if (accessModelClass == Short.TYPE) {
                this.modelClass = Short.class;
            } else {
                if (accessModelClass != Character.TYPE) throw new IllegalArgumentException("Unssuported primitive type: " + accessModelClass);
                this.modelClass = Character.class;
            }
        } else {
            this.modelClass = accessModelClass;
        }
        try {
            this.stringBasedConstructor = this.modelClass.getConstructor(String.class);
            return;
        }
        catch (Exception e) {
            throw new IllegalStateException("No string-based constructor found for " + this.modelClass);
        }
    }

    public JComponent getObjectComponent() {
        if (this.component == null) {
            this.component = new JTextField(8);
            this.component.setMinimumSize(this.component.getPreferredSize());
            this.registerFocusListener(this.component);
            this.synchronizeEditableState();
            this.updateView();
        }
        return this.component;
    }

    protected void synchronizeEditableState() {
        if (this.component != null) {
            this.component.setEditable(this.isEditable());
            this.component.setEnabled(this.isEnabled());
        }
    }

    protected boolean isViewReady() {
        return this.component != null;
    }

    protected Object getViewValue() {
        Number viewValue = null;
        String text = this.component.getText();
        if (text != null && !(text = text.trim()).equals("")) {
            viewValue = this.createNumber(text);
        }
        if (viewValue == null && this.isPrimitive) {
            viewValue = this.createNumber("0");
        }
        return viewValue;
    }

    private Number createNumber(String text) {
        Number num;
        try {
            num = (Number)this.stringBasedConstructor.newInstance(text);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bad view value '" + text + "' for " + this.modelClass + ": exception = " + e));
            }
            try {
                num = this.isPrimitive ? (Number)((Number)this.stringBasedConstructor.newInstance("0")) : (Number)null;
                this.component.setText(this.isPrimitive ? "0" : "");
            }
            catch (Exception ee) {
                throw new IllegalStateException("Cannot construct Number form string '" + text + "'", e);
            }
        }
        return num;
    }

    protected void setViewValue(Object modelValue) {
        String strValue = modelValue == null ? "" : modelValue.toString();
        this.component.setText(strValue);
    }
}

