/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.sfac.gui.editor.EditorContext;
import net.sf.sfac.gui.editor.EditorFactory;
import net.sf.sfac.gui.editor.ModelAccess;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.gui.editor.cmp.BaseObjectEditor;
import net.sf.sfac.gui.utils.ObjectSelectionListener;
import net.sf.sfac.gui.utils.ObjectSelector;
import net.sf.sfac.lang.LanguageListener;
import net.sf.sfac.lang.LanguageSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiObjectEditor
extends BaseObjectEditor
implements EditorContext,
LanguageListener,
ObjectSelector {
    private static Log log = LogFactory.getLog(MultiObjectEditor.class);
    private static final int HISTORY_SIZE = 20;
    private Map<Object, Object> userObjects;
    private JPanel editorPane;
    private CardLayout editorPaneLayout;
    private Object currentEdited;
    private ObjectEditor currentEditor;
    private int currentObjectIndex = -1;
    private List<Object> lastEditedObjects;
    private List<ObjectSelectionListener> listeners;
    private Map<String, ObjectEditor> editors = new HashMap<String, ObjectEditor>();
    private JLabel defaultDisplay;

    public MultiObjectEditor() {
        this.lastEditedObjects = new ArrayList<Object>();
    }

    protected String getNoSelectionMessage() {
        return LanguageSupport.getOptionalLocalizedString((String)"SELECT_A_NODE", (String)"Select a node.");
    }

    @Override
    public void edit(Object objToEdit) {
        if (this.currentEdited != objToEdit) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Change edited object from " + this.currentEdited + " to " + objToEdit));
            }
            ObjectEditor newEditor = null;
            String editedObjectClassName = null;
            if (objToEdit != null && (newEditor = this.editors.get(editedObjectClassName = objToEdit.getClass().getName())) == null) {
                EditorFactory edFactory = this.getEditorFactory();
                if (edFactory == null) {
                    edFactory = EditorFactory.getInstance();
                }
                newEditor = edFactory.createEditor(objToEdit.getClass());
                newEditor.setEditorContext(this);
                newEditor.addEditorModificationListener(this.getEditorModificationSupport().getListenerForSubEditors());
                this.editors.put(editedObjectClassName, newEditor);
                this.getEditorComponent().add((Component)newEditor.getEditorComponent(), editedObjectClassName);
            }
            if (this.currentEditor != null) {
                this.currentEditor.updateModel();
                if (this.currentEditor != newEditor) {
                    this.currentEditor.edit(null);
                }
            }
            this.currentEditor = newEditor;
            this.currentEdited = objToEdit;
            this.adaptHistoryList(objToEdit);
            if (newEditor == null) {
                log.info((Object)("No editor pane found to edit node " + objToEdit));
                this.editorPaneLayout.show(this.editorPane, "noNode");
            } else {
                log.info((Object)("Display editor pane " + this.currentEditor + " to edit node " + objToEdit));
                newEditor.edit(objToEdit);
                this.editorPaneLayout.show(this.editorPane, editedObjectClassName);
            }
            this.synchronizeEditableState();
            this.fireObjectSelectionChanged();
            this.getEditorComponent().invalidate();
            this.getEditorComponent().revalidate();
        }
    }

    @Override
    public Object getEditedObject() {
        return this.currentEdited;
    }

    @Override
    public void setModelAccess(ModelAccess newModelAccess) {
        throw new IllegalArgumentException("ModelAccess of " + this.getClass() + " cannot be customized");
    }

    private void adaptHistoryList(Object edited) {
        int len = this.lastEditedObjects.size();
        ++this.currentObjectIndex;
        if (this.currentObjectIndex < len) {
            if (edited != this.lastEditedObjects.get(this.currentObjectIndex)) {
                for (int i = len - 1; i > this.currentObjectIndex; --i) {
                    this.lastEditedObjects.remove(i);
                }
                this.lastEditedObjects.set(this.currentObjectIndex, edited);
            }
        } else {
            this.lastEditedObjects.add(edited);
        }
        if (this.lastEditedObjects.size() > 20) {
            this.lastEditedObjects.remove(0);
            --this.currentObjectIndex;
        }
    }

    public void moveInHistoryList(boolean forward) {
        int len = this.lastEditedObjects.size();
        if (forward) {
            if (this.currentObjectIndex < len - 1) {
                Object newEdited = this.lastEditedObjects.get(this.currentObjectIndex + 1);
                this.edit(newEdited);
            }
        } else if (this.currentObjectIndex >= 1) {
            this.currentObjectIndex -= 2;
            Object newEdited = this.lastEditedObjects.get(this.currentObjectIndex + 1);
            this.edit(newEdited);
        }
    }

    public boolean canMoveInHistory(boolean forward) {
        if (forward) {
            int len = this.lastEditedObjects.size();
            return this.currentObjectIndex < len - 1;
        }
        return this.currentObjectIndex >= 1;
    }

    public void clearHistory() {
        this.currentObjectIndex = -1;
        this.lastEditedObjects.clear();
    }

    @Override
    public EditorFactory getEditorFactory() {
        EditorContext editorContext = this.getEditorContext();
        return editorContext == null ? null : editorContext.getEditorFactory();
    }

    @Override
    public Object getContextObject(String objectKey) {
        EditorContext context;
        Object obj;
        Object object = obj = this.userObjects == null ? null : this.userObjects.get(objectKey);
        if (obj == null && (context = this.getEditorContext()) != null) {
            obj = context.getContextObject(objectKey);
        }
        return obj;
    }

    public void putContextObject(String objectKey, Object obj) {
        if (this.userObjects == null) {
            this.userObjects = new HashMap<Object, Object>();
        }
        this.userObjects.put(objectKey, obj);
    }

    @Override
    public boolean canEditInContext(boolean create, Class<?> objectClass, ObjectEditor source) {
        if (objectClass == null) {
            Thread.dumpStack();
            return false;
        }
        if (objectClass.getName().startsWith("java.")) {
            return false;
        }
        return !create;
    }

    @Override
    public <T> T editInContext(T obj, Class<T> objectClass, ObjectEditor source) {
        this.edit(obj);
        return null;
    }

    @Override
    public Collection<ObjectEditor> getEditors() {
        return this.editors.values();
    }

    public void languageChanged(Locale newLocale) {
        this.defaultDisplay.setText(this.getNoSelectionMessage());
        for (ObjectEditor editor : this.getEditors()) {
            if (!(editor instanceof LanguageListener)) continue;
            ((LanguageListener)editor).languageChanged(newLocale);
        }
    }

    @Override
    public JComponent getEditorComponent() {
        if (this.editorPane == null) {
            this.editorPaneLayout = new CardLayout();
            this.editorPane = new JPanel(this.editorPaneLayout);
            this.defaultDisplay = new JLabel(this.getNoSelectionMessage());
            this.defaultDisplay.setHorizontalAlignment(0);
            this.editorPane.add((Component)this.defaultDisplay, "noNode");
        }
        return this.editorPane;
    }

    @Override
    public void updateView() {
        if (this.currentEditor != null) {
            this.currentEditor.updateView();
        }
    }

    @Override
    public void updateModel() {
        if (this.isEditable() && this.isEnabled() && this.currentEditor != null) {
            this.currentEditor.updateModel();
        }
    }

    @Override
    protected void synchronizeEditableState() {
        if (this.currentEditor != null) {
            this.currentEditor.setEditable(this.isEditable());
            this.currentEditor.setEnabled(this.isEnabled());
        }
    }

    @Override
    public JLabel getLabelComponent() {
        return null;
    }

    @Override
    public JComponent getObjectComponent() {
        return this.getEditorComponent();
    }

    @Override
    public boolean canSelectObjects(List<?> toSelect) {
        if (toSelect == null) {
            return true;
        }
        return toSelect.size() <= 1;
    }

    @Override
    public void clearSelection() {
        this.edit(null);
    }

    @Override
    public Object getSelectedObject() {
        return this.currentEdited;
    }

    @Override
    public int getSelectedObjectCount() {
        return this.currentEdited == null ? 0 : 1;
    }

    @Override
    public List<?> getSelectedObjects() {
        if (this.currentEdited == null) {
            return null;
        }
        return Collections.singletonList(this.currentEdited);
    }

    @Override
    public boolean isMultiSelectionEnabled() {
        return false;
    }

    @Override
    public void selectDefaultItem() {
        this.edit(null);
    }

    @Override
    public void selectObjects(List<?> toSelect) {
        if (toSelect == null || toSelect.size() == 0) {
            this.edit(null);
        }
        this.edit(toSelect.get(0));
    }

    @Override
    public void addObjectSelectionListener(ObjectSelectionListener lis) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ObjectSelectionListener>();
        }
        this.listeners.add(lis);
    }

    @Override
    public void removeObjectSelectionListener(ObjectSelectionListener lis) {
        if (this.listeners != null) {
            this.listeners.remove(lis);
        }
    }

    public void fireObjectSelectionChanged() {
        if (this.listeners != null) {
            for (ObjectSelectionListener lis : this.listeners) {
                lis.objectSelectionChanged(this);
            }
        }
    }
}

