/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import javax.swing.AbstractListModel;
import net.sf.sfac.gui.editor.ModelAccess;
import net.sf.sfac.gui.editor.access.IndexedModelAccess;
import net.sf.sfac.gui.editor.cmp.BaseObjectEditor;
import net.sf.sfac.utils.Comparison;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListObjectModel
extends AbstractListModel {
    private BaseObjectEditor editor;
    private IndexedModelAccess indexedAccess;

    public ListObjectModel() {
    }

    public ListObjectModel(BaseObjectEditor newEditor) {
        this.setEditor(newEditor);
    }

    public BaseObjectEditor getEditor() {
        return this.editor;
    }

    public void setEditor(BaseObjectEditor newEditor) {
        if (this.editor != null) {
            this.removeListDataListener(this.editor.getEditorModificationSupport().getListenerForListModel());
        }
        this.editor = newEditor;
        this.indexedAccess = null;
        if (this.editor != null) {
            this.addListDataListener(this.editor.getEditorModificationSupport().getListenerForListModel());
        }
    }

    protected IndexedModelAccess getIndexedAccess() {
        if (this.indexedAccess == null) {
            ModelAccess access = this.editor.getModelAccess();
            this.indexedAccess = access instanceof IndexedModelAccess ? (IndexedModelAccess)access : new IndexedModelAccess(access);
        }
        return this.indexedAccess;
    }

    public Class<?> getItemClass() {
        return this.getIndexedAccess().getModelClass();
    }

    @Override
    public int getSize() {
        return this.getIndexedAccess().getItemCount(this.editor.getEditedObject());
    }

    @Override
    public Object getElementAt(int index) {
        return this.getIndexedAccess().getItem(this.editor.getEditedObject(), index);
    }

    public boolean canAddItem() {
        return this.getIndexedAccess().canAddItem();
    }

    public void addItem(int index) {
        this.addItem(index, null);
    }

    public void addItem(int index, Object objectToAdd) {
        this.getIndexedAccess().addItem(this.editor.getEditedObject(), index, objectToAdd);
        this.fireIntervalAdded(this, index, index);
    }

    public boolean canRemoveItem() {
        return this.getIndexedAccess().canRemoveItem();
    }

    public void removeItem(int index) {
        this.getIndexedAccess().removeItem(this.editor.getEditedObject(), index);
        this.fireIntervalRemoved(this, index, index);
    }

    public boolean canSwitchItems() {
        return this.getIndexedAccess().canSwitchItem();
    }

    public void switchItems(int index1, int index2) {
        this.getIndexedAccess().switchItems(this.editor.getEditedObject(), index1, index2);
        this.fireContentsChanged(this, index1, index2);
    }

    public void fireDataChanged() {
        this.fireContentsChanged(this, 0, this.getSize());
    }

    public int indexOf(Object obj) {
        int len = this.getSize();
        for (int i = 0; i < len; ++i) {
            if (!Comparison.equals((Object)obj, (Object)this.getElementAt(i))) continue;
            return i;
        }
        return -1;
    }
}

