/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.sfac.gui.UiUtils;
import net.sf.sfac.gui.editor.EditorContext;
import net.sf.sfac.gui.editor.cmp.ListObjectModel;
import net.sf.sfac.gui.editor.cmp.PolymorphicObjectFactory;
import net.sf.sfac.gui.editor.cmp.SimpleObjectEditor;
import net.sf.sfac.gui.framework.ActionRepository;
import net.sf.sfac.gui.framework.SharedResources;
import net.sf.sfac.gui.utils.ObjectSelectionListener;
import net.sf.sfac.gui.utils.ObjectSelector;
import net.sf.sfac.lang.LanguageSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListObjectEditor
extends SimpleObjectEditor
implements ObjectSelector {
    private static Log log = LogFactory.getLog(ListObjectEditor.class);
    private ListObjectModel listModel;
    private List<ObjectSelectionListener> listeners;
    private PolymorphicObjectFactory factory;
    private JComponent editorPane;
    private JPanel objectPane;
    private JList listCmp;
    private JScrollPane scroll;
    private JToolBar toolbar;
    private ListCellRenderer renderer;
    private ActionRepository repo;
    private Action viewAction;
    private Action addAction;
    private Action removeAction;
    private Action moveUpAction;
    private Action moveDownAction;

    public ListObjectEditor() {
        this.listModel = this.createListModel();
        this.setDefaultProperties();
    }

    public ListObjectEditor(ListObjectModel externalListModel) {
        this.listModel = externalListModel;
        this.listModel.setEditor(this);
        this.setDefaultProperties();
    }

    private void setDefaultProperties() {
        this.setProperty("weightx", 1.0);
        this.setProperty("weighty", 1.0);
        this.setProperty("fill", 1);
    }

    public PolymorphicObjectFactory getObjectFactory() {
        return this.factory;
    }

    public void setObjectFactory(PolymorphicObjectFactory newFactory) {
        this.factory = newFactory;
    }

    protected boolean canViewItem() {
        EditorContext edContext = this.getEditorContext();
        return edContext != null && edContext.canEditInContext(false, this.listModel.getItemClass(), this);
    }

    protected boolean canAddItem() {
        return this.listModel.canAddItem();
    }

    protected boolean canRemoveItem() {
        return this.listModel.canRemoveItem();
    }

    public ListCellRenderer getCellRenderer() {
        return this.renderer;
    }

    public void setCellRenderer(ListCellRenderer newRenderer) {
        this.renderer = newRenderer;
    }

    protected ListObjectModel createListModel() {
        return new ListObjectModel(this);
    }

    protected ListObjectModel getListModel() {
        return this.listModel;
    }

    public JComponent getScrollComponent() {
        if (this.scroll == null) {
            this.scroll = new JScrollPane(this.getListComponent());
        }
        return this.scroll;
    }

    public JList getListComponent() {
        if (this.listCmp == null) {
            this.listCmp = this.createListComponent();
            this.configureListComponent(this.listCmp);
            this.synchronizeEditableState();
            this.updateView();
        }
        return this.listCmp;
    }

    protected JList createListComponent() {
        return new JList(this.listModel);
    }

    protected void configureListComponent(JList createdList) {
        createdList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ListObjectEditor.this.viewSelectedItem();
                }
            }
        });
        createdList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ListObjectEditor.this.checkActionStates();
                ListObjectEditor.this.fireObjectSelectionChanged();
            }
        });
        createdList.setSelectionMode(0);
        ListCellRenderer cellRenderer = this.getCellRenderer();
        if (cellRenderer != null) {
            createdList.setCellRenderer(cellRenderer);
        }
    }

    void checkActionStates() {
        boolean selected;
        boolean enabled = this.getEditedObject() != null && this.isEditable() && this.isEnabled();
        int selectedIndex = this.getSelectedIndex();
        boolean bl = selected = selectedIndex >= 0;
        if (this.viewAction != null) {
            this.viewAction.setEnabled(selected);
        }
        if (this.addAction != null) {
            this.addAction.setEnabled(enabled);
        }
        if (this.removeAction != null) {
            this.removeAction.setEnabled(enabled && selected);
        }
        if (this.moveUpAction != null) {
            this.moveUpAction.setEnabled(this.listModel.canSwitchItems() && enabled && selected && selectedIndex > 0);
            this.moveDownAction.setEnabled(this.listModel.canSwitchItems() && enabled && selected && selectedIndex < this.listModel.getSize() - 1);
        }
    }

    protected int getSelectedIndex() {
        int selectedIndex;
        int n = selectedIndex = this.listCmp == null ? -1 : this.listCmp.getSelectedIndex();
        if (selectedIndex >= this.listModel.getSize()) {
            selectedIndex = -1;
        }
        return selectedIndex;
    }

    @Override
    public JComponent getObjectComponent() {
        if (this.objectPane == null) {
            this.objectPane = new JPanel(new BorderLayout());
            this.objectPane.add((Component)this.getToolBar(), "North");
            this.objectPane.add((Component)this.getScrollComponent(), "Center");
        }
        return this.objectPane;
    }

    @Override
    public JComponent getEditorComponent() {
        if (this.editorPane == null) {
            this.editorPane = new JPanel(new GridBagLayout());
            JComponent theLabel = this.getLabelComponent();
            if (theLabel != null) {
                UiUtils.resizeLabelFont(theLabel, 1.4f, false);
                this.editorPane.add((Component)theLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 4, 0), 0, 0));
            }
            this.repo = new ActionRepository();
            this.createActions(this.repo);
            if (this.repo.getToolbarActionCount() > 0) {
                this.toolbar = this.repo.createToolBar();
                this.editorPane.add((Component)this.toolbar, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 4, 0), 0, 0));
            }
            this.editorPane.add((Component)this.getScrollComponent(), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.editorPane;
    }

    protected JToolBar getToolBar() {
        if (this.toolbar == null) {
            this.repo = new ActionRepository();
            this.createActions(this.repo);
            this.toolbar = this.repo.createToolBar();
        }
        return this.toolbar;
    }

    @Override
    public void updateModel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateView() {
        try {
            this.getEditorModificationSupport().setEnableEvents(false);
            this.listModel.fireDataChanged();
            this.checkActionStates();
        }
        finally {
            this.getEditorModificationSupport().setEnableEvents(true);
        }
    }

    protected void viewSelectedItem() {
        int index;
        if (this.canViewItem() && (index = this.listCmp.getSelectedIndex()) >= 0 && index < this.listModel.getSize()) {
            Object selected = this.listModel.getElementAt(index);
            this.getEditorContext().editInContext(selected, selected.getClass(), this);
        }
    }

    @Override
    protected void synchronizeEditableState() {
        if (this.listCmp != null) {
            boolean tableEnabled = this.isEditable() && this.isEnabled();
            this.listCmp.setEnabled(true);
            this.listCmp.setBackground(tableEnabled ? Color.WHITE : Color.LIGHT_GRAY);
            this.listCmp.setForeground(tableEnabled ? Color.BLACK : Color.DARK_GRAY);
            this.listCmp.repaint();
        }
        this.checkActionStates();
    }

    private void createActions(ActionRepository repos) {
        if (this.canViewItem()) {
            this.viewAction = repos.addAction("viewItem", "View", "View selected item", null, null, "a0", SharedResources.getIcon("view.png"), new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    ListObjectEditor.this.viewSelectedItem();
                }
            });
        }
        if (this.canAddItem()) {
            this.addAction = repos.addAction("addItem", "Add", "Add a new item", null, null, "a1", SharedResources.getIcon("addItem.png"), new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    ListObjectEditor.this.addItem(ae);
                }
            });
        }
        if (this.canRemoveItem()) {
            this.removeAction = repos.addAction("removeItem", "Remove", "Remove selected item", null, null, "a2", SharedResources.getIcon("removeItem.gif"), new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    ListObjectEditor.this.removeItem();
                }
            });
        }
        if (this.listModel.canSwitchItems()) {
            this.moveUpAction = repos.addAction("moveUp", "Move up", "Move selected item up", null, null, "a3", SharedResources.getIcon("moveUp.png"), new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    ListObjectEditor.this.moveItem(-1);
                }
            });
            this.moveDownAction = repos.addAction("moveDown", "Move down", "Move selected item down", null, null, "a4", SharedResources.getIcon("moveDown.png"), new AbstractAction(){

                public void actionPerformed(ActionEvent ae) {
                    ListObjectEditor.this.moveItem(1);
                }
            });
        }
    }

    protected void addItem(ActionEvent ae) {
        if (this.factory == null) {
            int selectedIndex = this.getSelectedIndex();
            if (selectedIndex < 0 || selectedIndex > this.listModel.getSize()) {
                selectedIndex = this.getListModel().getSize();
            }
            this.listModel.addItem(selectedIndex);
        } else {
            int nbrTypes;
            Class<?> modelClass = this.listModel.getIndexedAccess().getModelClass();
            List<String> availableTypes = this.factory.getAvailableObjectTypes(modelClass);
            int n = nbrTypes = availableTypes == null ? 0 : availableTypes.size();
            if (nbrTypes == 0) {
                log.error((Object)("No defined types to add in factory: " + this.factory));
            } else if (nbrTypes == 1) {
                this.addItem(availableTypes.get(0));
            } else if (ae.getSource() instanceof JComponent) {
                JComponent invoker = (JComponent)ae.getSource();
                JPopupMenu popup = new JPopupMenu();
                ActionListener lis = new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ListObjectEditor.this.addItem(e.getActionCommand());
                    }
                };
                for (int i = 0; i < nbrTypes; ++i) {
                    String key = availableTypes.get(i);
                    String value = LanguageSupport.getLocalizedString((String)key);
                    JMenuItem item = new JMenuItem(value);
                    item.setActionCommand(key);
                    item.addActionListener(lis);
                    popup.add(item);
                }
                popup.show(invoker, 0, invoker.getHeight());
            } else {
                log.error((Object)("Source of add event is not a JComponent but: " + ae.getSource()));
            }
        }
    }

    protected void addItem(String itemType) {
        Object newItem = this.factory.newIntance(itemType);
        this.addObjectItem(newItem);
    }

    protected void addObjectItem(Object newItem) {
        int newIndex = this.getSelectedIndex();
        if (newIndex < 0) {
            newIndex = this.listModel.getSize();
        }
        this.listModel.addItem(newIndex, newItem);
        this.listCmp.setSelectedIndex(newIndex);
    }

    protected void moveItem(int movment) {
        if (this.listModel.canSwitchItems()) {
            int selectedIndex = this.getSelectedIndex();
            int targetIndex = selectedIndex + movment;
            int rowCount = this.listModel.getSize();
            if (selectedIndex >= 0 && targetIndex >= 0 && selectedIndex < rowCount && targetIndex < rowCount) {
                this.listModel.switchItems(selectedIndex, targetIndex);
                this.listCmp.setSelectedIndex(targetIndex);
            }
        }
    }

    protected void removeItem() {
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex >= 0 && selectedIndex < this.listModel.getSize()) {
            this.listModel.removeItem(selectedIndex);
        }
    }

    @Override
    protected Object getViewValue() {
        return null;
    }

    @Override
    protected boolean isViewReady() {
        return this.listCmp != null;
    }

    @Override
    protected void setViewValue(Object newViewValue) {
    }

    @Override
    public void clearSelection() {
        if (this.listCmp != null) {
            this.listCmp.clearSelection();
        }
    }

    @Override
    public Object getSelectedObject() {
        return this.listCmp.getSelectedValue();
    }

    @Override
    public int getSelectedObjectCount() {
        return this.listCmp.getSelectedIndices().length;
    }

    public List<Object> getSelectedObjects() {
        return Arrays.asList(this.listCmp.getSelectedValues());
    }

    @Override
    public boolean isMultiSelectionEnabled() {
        return true;
    }

    @Override
    public void selectDefaultItem() {
        if (this.listCmp != null && this.listModel.getSize() > 0) {
            this.listCmp.setSelectedIndex(0);
        }
    }

    @Override
    public boolean canSelectObjects(List<?> toSelect) {
        Object newSelection = null;
        if (toSelect != null && toSelect.size() == 1) {
            newSelection = toSelect.get(0);
        }
        return newSelection == null || this.listModel.indexOf(newSelection) >= 0;
    }

    @Override
    public void selectObjects(List<?> toSelect) {
        Object newSelection = null;
        if (toSelect != null && toSelect.size() == 1) {
            newSelection = toSelect.get(0);
        }
        if (this.listCmp != null) {
            if (newSelection == null) {
                this.listCmp.clearSelection();
            } else {
                this.listCmp.setSelectedIndex(this.listModel.indexOf(newSelection));
            }
        }
    }

    @Override
    public void addObjectSelectionListener(ObjectSelectionListener lis) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ObjectSelectionListener>();
        }
        this.listeners.add(lis);
    }

    @Override
    public void removeObjectSelectionListener(ObjectSelectionListener lis) {
        if (this.listeners != null) {
            this.listeners.remove(lis);
        }
    }

    protected void fireObjectSelectionChanged() {
        if (this.listeners != null) {
            for (ObjectSelectionListener lis : this.listeners) {
                lis.objectSelectionChanged(this);
            }
        }
    }
}

