/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import java.lang.reflect.Method;
import net.sf.sfac.editor.EditorConfig;
import net.sf.sfac.gui.editor.EditorConfigHelper;
import net.sf.sfac.gui.editor.EditorFactory;
import net.sf.sfac.gui.editor.ModelAccess;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.gui.editor.access.ChainableModelAccess;
import net.sf.sfac.gui.editor.access.IndexedModelAccess;
import net.sf.sfac.gui.editor.access.ReflexionModelAccess;
import net.sf.sfac.gui.editor.cmp.CompositeObjectEditor;
import net.sf.sfac.gui.editor.cmp.EmbededObjectEditor;
import net.sf.sfac.gui.editor.cmp.TableObjectEditor;
import net.sf.sfac.string.StringUtils;
import net.sf.sfac.utils.ReflectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericObjectEditor
extends CompositeObjectEditor {
    private static Log log = LogFactory.getLog(GenericObjectEditor.class);
    private Class<?> editedClass;

    public GenericObjectEditor() {
    }

    public GenericObjectEditor(Class<?> theEditedClass) {
        this.setupForEditedClass(theEditedClass);
    }

    public void setupForEditedClass(Class<?> theEditedClass) {
        this.setEditedClass(theEditedClass);
        EditorConfig editorClassAnnotation = this.getClassAnnotation(theEditedClass);
        if (editorClassAnnotation == null) {
            this.setLabel(StringUtils.firstToLowerCase((String)theEditedClass.getSimpleName()));
        } else {
            EditorConfigHelper.setProperties(this, editorClassAnnotation, theEditedClass.getSimpleName());
        }
        this.addSubEditors();
    }

    private EditorConfig getClassAnnotation(Class<?> theEditedClass) {
        EditorConfig annotation = null;
        for (Class<?> clazz = theEditedClass; annotation == null && clazz != null; clazz = clazz.getSuperclass()) {
            annotation = clazz.getAnnotation(EditorConfig.class);
        }
        return annotation;
    }

    public void setEditedClass(Class<?> theEditedClass) {
        if (theEditedClass == null) {
            throw new IllegalArgumentException("The edited class cannot be null");
        }
        if (this.editedClass == null) {
            this.editedClass = theEditedClass;
        } else if (this.editedClass != theEditedClass) {
            throw new IllegalStateException("Cannot change the edited class from " + this.editedClass + " to " + theEditedClass);
        }
    }

    @Override
    public void setProperty(String name, Object value) {
        if (name.equals("modelClass")) {
            this.setupForEditedClass((Class)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Object getProperty(String name, Object defaultValue) {
        if (name.equals("modelClass")) {
            return this.editedClass;
        }
        return super.getProperty(name, defaultValue);
    }

    protected void addSubEditors() {
        log.info((Object)("Create GenericObjectEditor for " + this.editedClass));
        int nbrAdded = this.addSubEditorsByAnnotations(this.editedClass, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)(" -> " + nbrAdded + " EditorConfig annotations processed"));
        }
        if (nbrAdded == 0) {
            this.addSubEditorsByIntrospection(this.editedClass);
        }
    }

    public int addSubEditorsByAnnotations(Class<?> theEditedClass, ModelAccess parentAccess) {
        int annotationsFound = 0;
        for (Method getter : theEditedClass.getMethods()) {
            EditorConfig fieldAnnotation = getter.getAnnotation(EditorConfig.class);
            if (fieldAnnotation == null) continue;
            boolean indexedGetter = IndexedModelAccess.isIndexedGetter(getter);
            Class<?> fieldType = getter.getReturnType();
            if ("embed".equals(fieldAnnotation.type())) {
                if (indexedGetter) {
                    throw new IllegalStateException("Cannot embed an indexed getter");
                }
                ReflexionModelAccess access = new ReflexionModelAccess(theEditedClass, getter);
                access.setParent(parentAccess);
                this.addSubEditorsByAnnotations(fieldType, access);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add editor for " + getter + ", indexed = " + indexedGetter));
            }
            ObjectEditor editor = null;
            Class<?> editorClass = EditorFactory.getEditorClass(fieldAnnotation);
            if (editorClass == null) {
                Class defaultEditorClass = indexedGetter ? TableObjectEditor.class : EmbededObjectEditor.class;
                editor = EditorFactory.getInstance().createEditor(fieldType, defaultEditorClass);
            } else {
                try {
                    editor = (ObjectEditor)editorClass.newInstance();
                    editor.setProperty("modelClass", fieldType);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot instanciate editor " + editorClass + " specified in @EditorConfig", e);
                }
            }
            ChainableModelAccess access = indexedGetter ? new IndexedModelAccess(theEditedClass, getter) : new ReflexionModelAccess(theEditedClass, getter);
            access.setParent(parentAccess);
            editor.setModelAccess(access);
            EditorConfigHelper.setProperties(editor, fieldAnnotation, ReflectionUtils.getFieldName((Method)getter));
            this.addChildEditor(editor);
            ++annotationsFound;
        }
        return annotationsFound;
    }

    protected void addSubEditorsByIntrospection(Class<?> theEditedClass) {
        log.info((Object)"! Add field editors by instrospection.");
        for (Method getter : theEditedClass.getDeclaredMethods()) {
            Class<?> returnType = getter.getReturnType();
            String methodName = getter.getName();
            if (!methodName.startsWith("get") && (!methodName.startsWith("is") || !returnType.equals(Boolean.TYPE))) continue;
            this.addSubEditor(-1, ReflectionUtils.getFieldName((Method)getter), getter);
        }
    }

    public void addSubEditor(int index, String fieldLabel, Method getter) {
        Class<?> fieldType = getter.getReturnType();
        ObjectEditor editor = EditorFactory.getInstance().createEditor(fieldType, EmbededObjectEditor.class);
        editor.setProperty("label", fieldLabel);
        editor.setModelAccess(new ReflexionModelAccess(this.editedClass, getter));
        this.addChildEditor(editor);
    }
}

