/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.sfac.gui.editor.cmp.SimpleObjectEditor;
import net.sf.sfac.gui.utils.FileDropListener;
import net.sf.sfac.lang.LanguageSupport;

public class FileEditor
extends SimpleObjectEditor {
    private int fileType;
    private JPanel component;
    private JTextField fileNameField;
    private JButton browseButton;

    public FileEditor() {
        this.fileType = 0;
    }

    public FileEditor(int possibleFileType) {
        this.fileType = possibleFileType;
    }

    protected int getFileType() {
        return this.fileType;
    }

    protected void setFileType(int newFileType) {
        this.fileType = newFileType;
    }

    public JComponent getObjectComponent() {
        if (this.component == null) {
            this.fileNameField = new JTextField(14);
            this.registerFocusListener(this.fileNameField);
            FileDropListener dropListener = new FileDropListener(new FileDropListener.FileDropTarget(){

                public void filesDropped(File[] files, int dropAction) {
                    if (files != null && files.length > 0) {
                        FileEditor.this.fileDropped(files[0]);
                    }
                }
            }, null);
            dropListener.registerToComponent(this.fileNameField);
            Dimension tfSize = this.fileNameField.getPreferredSize();
            this.browseButton = new JButton("...");
            this.browseButton.setPreferredSize(new Dimension(tfSize.height, tfSize.height));
            this.browseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileEditor.this.browse();
                }
            });
            this.browseButton.setToolTipText(LanguageSupport.getLocalizedString((String)"OPEN_FILE_CHOOSER", (Object[])new Object[]{"Open file chooser"}));
            this.component = new JPanel(new BorderLayout());
            this.component.add((Component)this.fileNameField, "Center");
            this.component.add((Component)this.browseButton, "East");
            this.synchronizeEditableState();
            this.updateView();
        }
        return this.component;
    }

    void fileDropped(File f) {
        if (f != null && this.fileType == 1 && !f.isDirectory()) {
            f = f.getParentFile();
        }
        if (f != null && this.fileNameField != null) {
            this.fileNameField.setText(f.getAbsolutePath());
        }
    }

    void browse() {
        int returnVal;
        File currentFile = new File(this.fileNameField.getText());
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(this.fileType);
        if (currentFile.exists()) {
            chooser.setCurrentDirectory(currentFile.getParentFile());
            chooser.setSelectedFile(currentFile);
        }
        if ((returnVal = chooser.showDialog(this.browseButton, LanguageSupport.getLocalizedString((String)"CHOOSE", (Object[])new Object[]{"Choose"}))) == 0) {
            File f = chooser.getSelectedFile();
            String text = f.getAbsolutePath();
            this.fileNameField.setText(text);
            this.updateModel();
        }
    }

    protected void synchronizeEditableState() {
        if (this.fileNameField != null) {
            this.fileNameField.setEditable(this.isEditable());
            this.fileNameField.setEnabled(this.isEnabled());
            this.browseButton.setEnabled(this.isEditable() || this.isEnabled());
        }
    }

    protected boolean isViewReady() {
        return this.component != null;
    }

    protected Object getViewValue() {
        File fil = null;
        String text = this.fileNameField.getText();
        if (text != null && !(text = text.trim()).equals("")) {
            fil = new File(text);
        }
        return fil;
    }

    protected void setViewValue(Object modelValue) {
        File fil = (File)modelValue;
        String modelText = fil == null ? "" : fil.getAbsolutePath();
        this.fileNameField.setText(modelText);
    }

    public void setProperty(String name, Object value) {
        if (name.equals("type")) {
            String type = (String)value;
            if (type.equalsIgnoreCase("file")) {
                this.fileType = 0;
            } else if (type.equalsIgnoreCase("directory")) {
                this.fileType = 1;
            } else if (type.equalsIgnoreCase("fileAndDirectory")) {
                this.fileType = 2;
            }
        } else {
            super.setProperty(name, value);
        }
    }

    public Object getProperty(String name, Object defaultValue) {
        if (name.equals("type")) {
            if (this.fileType == 1) {
                return "directory";
            }
            if (this.fileType == 2) {
                return "fileAndDirectory";
            }
            return "file";
        }
        return super.getProperty(name, defaultValue);
    }
}

