/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.sfac.gui.editor.ModelAccess;
import net.sf.sfac.gui.editor.cmp.SimpleObjectEditor;
import net.sf.sfac.gui.utils.ComboBoxKeyManager;
import net.sf.sfac.lang.LanguageSupport;
import net.sf.sfac.utils.Comparison;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumEditor
extends SimpleObjectEditor {
    EnumHolder[] enumValues;
    private JComponent component;
    private JRadioButton[] radios;
    private JComboBox combo;
    private boolean allowNullValue = true;

    public EnumEditor() {
    }

    public EnumEditor(Class<? extends Enum<?>> enumerationClass) {
        this.initEnumValues(enumerationClass);
    }

    @Override
    public void setModelAccess(ModelAccess newModelAccess) {
        super.setModelAccess(newModelAccess);
        this.initEnumValues(newModelAccess.getModelClass());
    }

    private void initEnumValues(Class<? extends Enum<?>> enumerationClass) {
        Enum<?>[] values = enumerationClass.getEnumConstants();
        if (values == null) {
            throw new IllegalArgumentException("" + enumerationClass + " does not have accessible enum values");
        }
        int len = values.length;
        this.enumValues = new EnumHolder[len];
        for (int i = 0; i < len; ++i) {
            this.enumValues[i] = new EnumHolder(values[i]);
        }
        Arrays.sort(this.enumValues);
    }

    @Override
    public JComponent getObjectComponent() {
        if (this.component == null) {
            if (this.enumValues.length > 4) {
                this.combo = new JComboBox(new EnumComboModel());
                this.combo.setKeySelectionManager(new ComboBoxKeyManager());
                this.combo.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent ie) {
                        if (ie.getStateChange() == 1) {
                            EnumEditor.this.updateModel();
                        }
                    }
                });
                this.component = this.combo;
            } else {
                this.component = new JPanel();
                this.component.setLayout(new BoxLayout(this.component, 0));
                ButtonGroup group = new ButtonGroup();
                int len = this.enumValues.length;
                this.radios = new JRadioButton[len];
                ActionListener al = new ActionListener(){

                    public void actionPerformed(ActionEvent newE) {
                        EnumEditor.this.updateModel();
                    }
                };
                for (int i = 0; i < len; ++i) {
                    JRadioButton radio = new JRadioButton(String.valueOf(this.enumValues[i]));
                    radio.addActionListener(al);
                    EnumEditor.adjustSize(radio);
                    group.add(radio);
                    if (i > 0) {
                        this.component.add(Box.createHorizontalStrut(5));
                    }
                    this.component.add(radio);
                    this.radios[i] = radio;
                }
            }
            this.synchronizeEditableState();
            this.updateView();
        }
        return this.component;
    }

    @Override
    protected void synchronizeEditableState() {
        boolean cmpEnabled;
        boolean bl = cmpEnabled = this.isEditable() && this.isEnabled();
        if (this.combo != null) {
            this.combo.setEnabled(cmpEnabled);
        } else if (this.radios != null) {
            for (JRadioButton radio : this.radios) {
                radio.setEnabled(cmpEnabled);
            }
        }
    }

    @Override
    protected boolean isViewReady() {
        return this.combo != null || this.radios != null;
    }

    @Override
    protected Object getViewValue() {
        Enum<?> value = null;
        if (this.combo != null) {
            EnumHolder holder = (EnumHolder)this.combo.getSelectedItem();
            value = holder == null ? null : holder.getModelValue();
        } else if (this.radios != null) {
            int len = this.enumValues.length;
            for (int i = 0; i < len; ++i) {
                if (!this.radios[i].isSelected()) continue;
                value = this.enumValues[i].getModelValue();
                break;
            }
        }
        return value;
    }

    @Override
    protected void setViewValue(Object modelValue) {
        if (this.combo != null) {
            this.combo.setSelectedItem(this.getHolder((Enum)modelValue));
        } else if (this.radios != null) {
            int len = this.enumValues.length;
            for (int i = 0; i < len; ++i) {
                if (!this.enumValues[i].getModelValue().equals(modelValue)) continue;
                this.radios[i].setSelected(true);
                break;
            }
        }
    }

    private EnumHolder getHolder(Enum<?> modelValue) {
        if (modelValue != null) {
            int len = this.enumValues.length;
            for (int i = 0; i < len; ++i) {
                if (!this.enumValues[i].getModelValue().equals(modelValue)) continue;
                return this.enumValues[i];
            }
        }
        return null;
    }

    boolean getAllowNullValue() {
        return this.allowNullValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EnumHolder
    implements Comparable<EnumHolder> {
        private Enum<?> modelValue;
        private String displayValue;

        public EnumHolder(Enum<?> value) {
            this.modelValue = value;
            String key = value.getClass().getSimpleName() + "." + this.modelValue.name();
            this.displayValue = LanguageSupport.getOptionalLocalizedString((String)key, (String)this.modelValue.toString());
        }

        public boolean match(Enum<?> value) {
            return this.modelValue == value;
        }

        public Enum<?> getModelValue() {
            return this.modelValue;
        }

        public String toString() {
            return this.displayValue;
        }

        @Override
        public int compareTo(EnumHolder other) {
            if (other == null) {
                return -1;
            }
            return Comparison.compareStrings((String)this.displayValue, (String)other.displayValue);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            return this.compareTo((EnumHolder)other) == 0;
        }

        public int hashCode() {
            return this.displayValue == null ? 0 : this.displayValue.hashCode();
        }
    }

    class EnumComboModel
    extends AbstractListModel
    implements ComboBoxModel {
        private Object selected;

        EnumComboModel() {
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public void setSelectedItem(Object anItem) {
            if (anItem != null || EnumEditor.this.getAllowNullValue()) {
                this.selected = anItem;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getElementAt(int newIndex) {
            return EnumEditor.this.enumValues[newIndex];
        }

        public int getSize() {
            return EnumEditor.this.enumValues.length;
        }
    }
}

