/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.sfac.gui.editor.EditorContext;
import net.sf.sfac.gui.editor.cmp.SimpleObjectEditor;
import net.sf.sfac.lang.LanguageSupport;

public class EmbededObjectEditor
extends SimpleObjectEditor {
    private JPanel component;
    private JTextField objectTextField;
    private JButton browseButton;

    public JComponent getObjectComponent() {
        if (this.component == null) {
            this.objectTextField = new JTextField(25);
            this.registerFocusListener(this.objectTextField);
            Dimension tfSize = this.objectTextField.getPreferredSize();
            this.browseButton = new JButton("...");
            this.browseButton.setPreferredSize(new Dimension(tfSize.height, tfSize.height));
            this.browseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EmbededObjectEditor.this.openSubEditor();
                }
            });
            this.browseButton.setToolTipText(LanguageSupport.getLocalizedString((String)"VIEW_ITEM", (Object[])new Object[]{"View Item"}));
            this.browseButton.setEnabled(this.canViewItem());
            this.component = new JPanel(new BorderLayout());
            this.component.add((Component)this.objectTextField, "Center");
            this.component.add((Component)this.browseButton, "East");
            this.synchronizeEditableState();
            this.updateView();
        }
        return this.component;
    }

    void openSubEditor() {
        EditorContext context = this.getEditorContext();
        if (context != null) {
            this.browseButton.setEnabled(false);
            Object result = context.editInContext(this.getModelValue(), this.getModelAccess().getModelClass(), this);
            if (result != null && this.isEditable() && this.isEnabled()) {
                this.setViewValue(result);
                this.updateModel();
            }
            this.browseButton.setEnabled(this.canViewItem());
        }
    }

    protected boolean canViewItem() {
        EditorContext edContext = this.getEditorContext();
        return edContext != null && edContext.canEditInContext(false, this.getModelAccess().getModelClass(), this);
    }

    protected void synchronizeEditableState() {
        if (this.objectTextField != null) {
            this.objectTextField.setEditable(false);
            this.objectTextField.setEnabled(this.isEnabled());
        }
    }

    protected boolean isViewReady() {
        return this.objectTextField != null;
    }

    protected Object getViewValue() {
        return null;
    }

    public void updateModel() {
    }

    public void setModelValue(Object newValue) {
    }

    protected void setViewValue(Object modelValue) {
        String strValue = modelValue == null ? "" : modelValue.toString();
        this.objectTextField.setText(strValue);
    }

    protected boolean valueHasChanged(Object oldValue, Object newValue) {
        return false;
    }
}

