/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.sfac.gui.editor.cmp.SimpleObjectEditor;
import net.sf.sfac.utils.Comparison;

public class DimensionEditor
extends SimpleObjectEditor {
    private JPanel component;
    private JTextField widthField;
    private JTextField heightField;

    public JComponent getObjectComponent() {
        if (this.component == null) {
            this.widthField = new JTextField(6);
            this.registerFocusListener(this.widthField);
            this.heightField = new JTextField(6);
            this.registerFocusListener(this.heightField);
            this.component = new JPanel(new GridBagLayout());
            this.component.add((Component)this.widthField, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
            this.component.add((Component)new JLabel("x"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
            this.component.add((Component)this.heightField, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.component.add((Component)new JLabel(), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
            this.synchronizeEditableState();
            this.updateView();
        }
        return this.component;
    }

    protected void synchronizeEditableState() {
        if (this.widthField != null) {
            this.widthField.setEditable(this.isEditable());
            this.widthField.setEnabled(this.isEnabled());
            this.heightField.setEditable(this.isEditable());
            this.heightField.setEnabled(this.isEnabled());
        }
    }

    protected boolean isViewReady() {
        return this.widthField != null;
    }

    protected Object getViewValue() {
        int width = this.getIntValue(this.widthField);
        int height = this.getIntValue(this.heightField);
        if (width < 0 || height < 0) {
            return null;
        }
        return new Dimension(width, height);
    }

    private int getIntValue(JTextField field) {
        int result = -1;
        String text = field.getText();
        if (Comparison.isDefined((String)text)) {
            try {
                result = Integer.parseInt(text);
            }
            catch (Exception e) {
                field.setText("");
            }
        }
        return result;
    }

    protected void setViewValue(Object modelValue) {
        Dimension dim = (Dimension)modelValue;
        if (dim == null) {
            this.widthField.setText("");
            this.heightField.setText("");
        } else {
            this.widthField.setText(String.valueOf(dim.width));
            this.heightField.setText(String.valueOf(dim.height));
        }
    }
}

