/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.sfac.gui.editor.cmp.SimpleObjectEditor;
import net.sf.sfac.lang.LanguageSupport;
import net.sf.sfac.utils.Comparison;

public class DateEditor
extends SimpleObjectEditor {
    private DateType type;
    private DateFormat format;
    private JPanel component;
    private JTextField dateField;
    private JButton browseButton;

    public DateEditor() {
        this.setTypeOfDate(DateType.DATE);
    }

    public DateEditor(DateType typeOfDate) {
        this.setTypeOfDate(typeOfDate);
    }

    public void setTypeOfDate(DateType typeOfDate) {
        if (this.type != typeOfDate) {
            this.type = typeOfDate;
            switch (this.type) {
                case DATE_TIME: {
                    this.format = DateFormat.getDateTimeInstance();
                    break;
                }
                case TIME: {
                    this.format = DateFormat.getTimeInstance();
                    break;
                }
                case DATE: {
                    this.format = DateFormat.getDateInstance();
                }
            }
        }
    }

    public DateType getTypeOfDate() {
        return this.type;
    }

    public JComponent getObjectComponent() {
        if (this.component == null) {
            this.dateField = new JTextField(25);
            this.registerFocusListener(this.dateField);
            Dimension tfSize = this.dateField.getPreferredSize();
            this.browseButton = new JButton("...");
            this.browseButton.setPreferredSize(new Dimension(tfSize.height, tfSize.height));
            this.browseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DateEditor.this.chooseDate();
                }
            });
            String tooltip = LanguageSupport.getLocalizedString((String)"OPEN_DATE_CHOOSER", (Object[])new Object[]{"Open date chooser"});
            this.browseButton.setToolTipText(tooltip);
            this.component = new JPanel(new BorderLayout());
            this.component.add((Component)this.dateField, "Center");
            this.component.add((Component)this.browseButton, "East");
            this.synchronizeEditableState();
            this.updateView();
        }
        return this.component;
    }

    void chooseDate() {
    }

    protected void synchronizeEditableState() {
        if (this.dateField != null) {
            this.dateField.setEditable(this.isEditable());
            this.dateField.setEnabled(this.isEnabled());
        }
    }

    protected boolean isViewReady() {
        return this.dateField != null;
    }

    protected Object getViewValue() {
        Date d = null;
        String text = this.dateField.getText();
        if (text != null) {
            try {
                d = this.format.parse(text);
            }
            catch (Exception e) {
                d = (Date)this.getModelValue();
                this.setViewValue(d);
            }
        }
        return d;
    }

    protected void setViewValue(Object modelValue) {
        Date modelDate = (Date)modelValue;
        String strDate = modelDate == null ? "" : this.format.format(modelDate);
        this.dateField.setText(strDate);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String name, Object value) {
        if (name.equals("type")) {
            String typeStr = (String)value;
            if (typeStr.equalsIgnoreCase("date")) {
                this.setTypeOfDate(DateType.DATE);
                return;
            } else if (typeStr.equalsIgnoreCase("dateTime")) {
                this.setTypeOfDate(DateType.DATE_TIME);
                return;
            } else {
                if (!typeStr.equalsIgnoreCase("time")) throw new IllegalArgumentException("Unknown date type: " + value);
                this.setTypeOfDate(DateType.TIME);
            }
            return;
        } else {
            super.setProperty(name, value);
        }
    }

    public Object getProperty(String name, Object defaultValue) {
        if (name.equals("type")) {
            if (this.type == DateType.DATE_TIME) {
                return "dateTime";
            }
            if (this.type == DateType.TIME) {
                return "time";
            }
            return "date";
        }
        return super.getProperty(name, defaultValue);
    }

    protected boolean valueHasChanged(Object oldValue, Object newValue) {
        if (oldValue == newValue) {
            return false;
        }
        if (oldValue == null) {
            return true;
        }
        if (newValue == null) {
            return true;
        }
        return !Comparison.stringEquals((Object)this.format.format((Date)oldValue), (Object)this.format.format((Date)newValue));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DateType {
        DATE,
        DATE_TIME,
        TIME;

    }
}

