/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.sf.sfac.gui.UiUtils;
import net.sf.sfac.gui.cmp.RollOverSplitPane;
import net.sf.sfac.gui.editor.EditorContext;
import net.sf.sfac.gui.editor.EditorFactory;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.gui.editor.cmp.BaseObjectEditor;
import net.sf.sfac.lang.LanguageSupport;
import net.sf.sfac.utils.Comparison;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeObjectEditor
extends BaseObjectEditor
implements EditorContext {
    private static Log log = LogFactory.getLog(CompositeObjectEditor.class);
    private static final EditorComparator EDITOR_COMPARATOR = new EditorComparator();
    public static final Integer MAX_INTEGER = Integer.MAX_VALUE;
    private static final int UNSPECIFIED = Integer.MIN_VALUE;
    private List<ObjectEditor> subEditors = new ArrayList<ObjectEditor>();
    private JComponent editorCmp;
    private JComponent leftCmp;
    private JComponent topCmp;
    private JComponent objectCmp;
    private JTabbedPane tabbedPane;
    private JLabel descriptionLabel;
    protected int nbrColumnsForEditor = 1;
    protected boolean addEmptyLabelAtEnd;

    @Override
    public void edit(Object objToEdit) {
        super.edit(objToEdit);
        Object edited = this.getModelValue();
        int len = this.getChildEditorCount();
        for (int i = 0; i < len; ++i) {
            this.getChildEditorAt(i).edit(edited);
        }
    }

    @Override
    public JComponent getEditorComponent() {
        if (this.editorCmp == null) {
            this.editorCmp = this.createEditorComponent();
        }
        return this.editorCmp;
    }

    protected String getEditorId() {
        return this.getClass().getSimpleName();
    }

    protected JComponent createEditorComponent() {
        JComponent editorPane;
        String splitLocationKey;
        RollOverSplitPane roll;
        JComponent centerComponent = this.getObjectComponent();
        if (this.leftCmp != null) {
            roll = new RollOverSplitPane(1, this.leftCmp, centerComponent);
            splitLocationKey = "editor." + this.getEditorId() + ".leftSplitLocation";
            roll.useSettings(this.getSettings(), splitLocationKey, 300);
            centerComponent = roll;
        }
        if (this.topCmp != null) {
            centerComponent.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            roll = new RollOverSplitPane(0, this.topCmp, centerComponent);
            splitLocationKey = "editor." + this.getEditorId() + ".topSplitLocation";
            roll.useSettings(this.getSettings(), splitLocationKey, 300);
            editorPane = roll;
        } else {
            JComponent titleLbl = this.getLabelComponent();
            if (titleLbl != null) {
                centerComponent.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
                editorPane = new JPanel(new BorderLayout());
                UiUtils.resizeLabelFont(titleLbl, 2.0f, true);
                editorPane.add((Component)titleLbl, "North");
                editorPane.add((Component)centerComponent, "Center");
            } else {
                editorPane = centerComponent;
            }
        }
        editorPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        return editorPane;
    }

    @Override
    public JComponent getObjectComponent() {
        if (this.objectCmp == null) {
            this.sortChildEditors();
            this.addEmptyLabelAtEnd = true;
            this.objectCmp = this.createEmptyObjectComponent();
            int len = this.getChildEditorCount();
            int row = 0;
            int maxRow = row = this.addDescriptionLabel(this.objectCmp, row);
            for (int i = 0; i < len; ++i) {
                ObjectEditor childEditor = this.getChildEditorAt(i);
                String position = (String)childEditor.getProperty("compositeObjectEditor.position", "center");
                if ("left".equals(position)) {
                    if (this.leftCmp != null) {
                        throw new IllegalStateException("Already an object as left pane");
                    }
                    this.leftCmp = childEditor.getObjectComponent();
                } else if ("top".equals(position)) {
                    if (this.topCmp != null) {
                        throw new IllegalStateException("Already an object as top pane");
                    }
                    this.topCmp = childEditor.getObjectComponent();
                } else {
                    String tab = (String)childEditor.getProperty("tab", null);
                    if (Comparison.isEmpty((String)tab)) {
                        row = this.addChildComponentInPanel(this.objectCmp, childEditor, row);
                    } else {
                        String tabTitle = LanguageSupport.getLocalizedString((String)tab);
                        if (this.tabbedPane == null) {
                            this.tabbedPane = new JTabbedPane();
                            this.objectCmp.add((Component)this.tabbedPane, new GridBagConstraints(0, 100, this.nbrColumnsForEditor + 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                        }
                        int tabIndex = this.tabbedPane.indexOfTab(tabTitle);
                        JPanel tabPanel = null;
                        if (tabIndex >= 0) {
                            tabPanel = (JPanel)this.tabbedPane.getComponent(tabIndex);
                        } else {
                            tabPanel = new JPanel(new GridBagLayout());
                            tabPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
                            this.tabbedPane.addTab(tabTitle, tabPanel);
                        }
                        row = this.addChildComponentInPanel(tabPanel, childEditor, row);
                        this.addEmptyLabelAtEnd = false;
                    }
                }
                if (maxRow >= row) continue;
                maxRow = row;
            }
            this.addEmptyLabel(this.objectCmp, maxRow + 1);
        }
        this.updateView();
        return this.objectCmp;
    }

    protected JComponent createEmptyObjectComponent() {
        return new JPanel(new GridBagLayout());
    }

    protected int addDescriptionLabel(JComponent pane, int row) {
        String descr = this.getTranslatedDescription();
        if (Comparison.isDefined((String)descr)) {
            this.descriptionLabel = new JLabel(descr);
            this.descriptionLabel.setHorizontalAlignment(0);
            this.descriptionLabel.setForeground(Color.DARK_GRAY);
            pane.add((Component)this.descriptionLabel, new GridBagConstraints(0, row, this.nbrColumnsForEditor + 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 10, 5), 0, 0));
            ++row;
        }
        return row;
    }

    @Override
    protected void updateDescriptionText() {
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setText(this.getTranslatedDescription());
        }
    }

    protected int addChildComponentInPanel(JComponent pane, ObjectEditor childEditor, int row) {
        int nextRow;
        int gridx = childEditor.getIntProperty("gridx", 1);
        int gridy = childEditor.getIntProperty("gridy", row);
        int gridwidth = childEditor.getIntProperty("gridwidth", this.nbrColumnsForEditor);
        int gridheight = childEditor.getIntProperty("gridwidth", 1);
        double weightx = childEditor.getDoubleProperty("weightx", 0.0);
        double weighty = childEditor.getDoubleProperty("weighty", 0.0);
        int fill = childEditor.getIntProperty("fill", 2);
        int anchor = childEditor.getIntProperty("anchor", 17);
        if (gridy < 0) {
            gridy = row + gridy;
            nextRow = row;
        } else {
            nextRow = gridy + 1;
        }
        if (gridwidth == Integer.MIN_VALUE) {
            gridwidth = this.nbrColumnsForEditor;
        }
        JComponent label = childEditor.getLabelComponent();
        JComponent subEditorCmp = childEditor.getObjectComponent();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add components of child editor: " + childEditor + " at position " + gridx + "," + gridy));
        }
        if (weighty > 0.0) {
            this.addEmptyLabelAtEnd = false;
        }
        if (label != null) {
            if (label instanceof JLabel) {
                ((JLabel)label).setLabelFor(subEditorCmp);
            }
            pane.add((Component)label, new GridBagConstraints(gridx - 1, gridy, 1, gridheight, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
        }
        pane.add((Component)subEditorCmp, new GridBagConstraints(gridx, gridy, gridwidth, gridheight, weightx, weighty, anchor, fill, new Insets(0, 0, 0, 0), 0, 0));
        return nextRow;
    }

    protected void addEmptyLabel(JComponent pane, int row) {
        if (this.addEmptyLabelAtEnd) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding empty label at grid position: 0," + row + " with weighty=1.0"));
            }
            JLabel emptyLabel = new JLabel();
            pane.add((Component)emptyLabel, new GridBagConstraints(0, row, 1, 1, 0.0, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateView() {
        try {
            this.getEditorModificationSupport().setEnableEvents(false);
            this.updateLabelText();
            this.updateDescriptionText();
            int len = this.getChildEditorCount();
            for (int i = 0; i < len; ++i) {
                this.getChildEditorAt(i).updateView();
            }
        }
        finally {
            this.getEditorModificationSupport().setEnableEvents(true);
        }
    }

    @Override
    protected void synchronizeEditableState() {
        int len = this.getChildEditorCount();
        for (int i = 0; i < len; ++i) {
            ObjectEditor childEditor = this.getChildEditorAt(i);
            childEditor.setEditable(this.isEditable());
            childEditor.setEnabled(this.isEnabled());
        }
    }

    @Override
    public void updateModel() {
        if (this.isEditable() && this.isEnabled()) {
            int len = this.getChildEditorCount();
            for (int i = 0; i < len; ++i) {
                this.getChildEditorAt(i).updateModel();
            }
        }
    }

    protected void sortChildEditors() {
        Collections.sort(this.subEditors, EDITOR_COMPARATOR);
    }

    public int getChildEditorCount() {
        return this.subEditors.size();
    }

    public ObjectEditor getChildEditor(String childEditorPath) {
        for (ObjectEditor ed : this.subEditors) {
            if (!childEditorPath.equals(ed.getModelAccess().getFieldPath())) continue;
            return ed;
        }
        return null;
    }

    public ObjectEditor getChildEditorAt(int index) {
        return this.subEditors.get(index);
    }

    public void addChildEditor(ObjectEditor newChild) {
        newChild.setEditorContext(this);
        newChild.addEditorModificationListener(this.getEditorModificationSupport().getListenerForSubEditors());
        this.subEditors.add(newChild);
    }

    public void removeChildEditor(ObjectEditor child) {
        this.subEditors.remove(child);
        child.setEditorContext(null);
        child.removeEditorModificationListener(this.getEditorModificationSupport().getListenerForSubEditors());
    }

    @Override
    public boolean canEditInContext(boolean create, Class<?> objectClass, ObjectEditor source) {
        EditorContext context = this.getEditorContext();
        return context == null ? false : context.canEditInContext(create, objectClass, source);
    }

    @Override
    public <T> T editInContext(T obj, Class<T> objectClass, ObjectEditor source) {
        return this.getEditorContext().editInContext(obj, objectClass, source);
    }

    @Override
    public Object getContextObject(String objectKey) {
        return this.getEditorContext().getContextObject(objectKey);
    }

    @Override
    public EditorFactory getEditorFactory() {
        return this.getEditorContext().getEditorFactory();
    }

    @Override
    public Collection<ObjectEditor> getEditors() {
        return this.subEditors;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EditorComparator
    implements Comparator<ObjectEditor> {
        EditorComparator() {
        }

        @Override
        public int compare(ObjectEditor ed1, ObjectEditor ed2) {
            Integer index1 = (Integer)ed1.getProperty("index", MAX_INTEGER);
            Integer index2 = (Integer)ed2.getProperty("index", MAX_INTEGER);
            return Comparison.compareTo((Comparable)index1, (Comparable)index2);
        }
    }
}

