/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.gui.editor.cmp.EnumEditor;

public abstract class ComponentVisibilityEditor
extends EnumEditor {
    private Map<String, ComponentHolder> holders;

    public void updateView() {
        super.updateView();
        this.updateComponentVisibility();
    }

    public void updateModel() {
        super.updateModel();
        if (this.holders != null) {
            this.updateComponentVisibility();
        }
    }

    public abstract void updateComponentVisibility();

    protected void setComponentVisible(String editorPath, boolean visible) {
        ComponentHolder holder;
        if (this.holders == null) {
            this.holders = new HashMap<String, ComponentHolder>();
        }
        if ((holder = this.holders.get(editorPath)) == null) {
            ObjectEditor ed = this.getSiblingEditor(editorPath);
            if (ed == null) {
                throw new IllegalArgumentException("No editor with path '" + editorPath + "' in context " + this.getEditorContext());
            }
            holder = new ComponentHolder(ed);
        }
        holder.setVisible(visible);
    }

    protected ObjectEditor getSiblingEditor(String editorPath) {
        for (ObjectEditor child : this.getEditorContext().getEditors()) {
            if (!editorPath.equals(child.getModelAccess().getFieldPath())) continue;
            return child;
        }
        return null;
    }

    private static class ComponentHolder {
        private JComponent label;
        private JComponent objectCmp;

        ComponentHolder(ObjectEditor ed) {
            this.label = ed.getLabelComponent();
            this.objectCmp = ed.getObjectComponent();
        }

        public void setVisible(boolean visible) {
            this.setComponentVisible(this.label, visible);
            this.setComponentVisible(this.objectCmp, visible);
        }

        private void setComponentVisible(Component cmp, boolean visible) {
            if (cmp != null) {
                Component[] subComponents;
                cmp.setVisible(visible);
                if (cmp instanceof Container && (subComponents = ((Container)cmp).getComponents()) != null) {
                    for (Component sub : subComponents) {
                        this.setComponentVisible(sub, visible);
                    }
                }
            }
        }
    }
}

