/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import net.sf.sfac.gui.editor.EditorContext;
import net.sf.sfac.gui.editor.cmp.ComboBoxEditorModel;
import net.sf.sfac.gui.editor.cmp.SimpleObjectEditor;
import net.sf.sfac.gui.utils.ComboBoxKeyManager;
import net.sf.sfac.gui.utils.ObjectSelectionListener;
import net.sf.sfac.gui.utils.ObjectSelector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboBoxEditor
extends SimpleObjectEditor
implements ObjectSelector {
    private static Log log = LogFactory.getLog(ComboBoxEditor.class);
    private ComboBoxEditorModel comboModel;
    private List<ObjectSelectionListener> listeners;
    private JPanel editionPane;
    private JPanel objectPane;
    private JComboBox combo;
    private ListCellRenderer renderer;
    private JButton openButton;
    private boolean allowedToOpen = true;

    public ComboBoxEditor(ComboBoxEditorModel model) {
        this(null, model);
    }

    public ComboBoxEditor(String label, ComboBoxEditorModel model) {
        this.setLabel(label);
        this.comboModel = model;
        this.comboModel.addListDataListener(new ListDataListener(){

            public void intervalRemoved(ListDataEvent e) {
            }

            public void intervalAdded(ListDataEvent e) {
            }

            public void contentsChanged(ListDataEvent e) {
                if (e.getIndex0() < 0 && e.getIndex1() < 0) {
                    ComboBoxEditor.this.updateModel();
                    ComboBoxEditor.this.fireObjectSelectionChanged();
                }
            }
        });
    }

    public ComboBoxEditorModel getComboBoxModel() {
        return this.comboModel;
    }

    public ListCellRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(ListCellRenderer comboRenderer) {
        this.renderer = comboRenderer;
    }

    public boolean isAllowedToOpen() {
        return this.allowedToOpen;
    }

    public void setAllowedToOpen(boolean newAllowedToOpen) {
        this.allowedToOpen = newAllowedToOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateView() {
        try {
            this.getEditorModificationSupport().setEnableEvents(false);
            this.comboModel.fireAllDataChanged();
            super.updateView();
        }
        finally {
            this.getEditorModificationSupport().setEnableEvents(true);
        }
    }

    @Override
    protected boolean isViewReady() {
        return this.combo != null;
    }

    @Override
    protected Object getViewValue() {
        return this.comboModel.getSelectedItem();
    }

    @Override
    protected void setViewValue(Object modelValue) {
        this.comboModel.setSelectedItem(modelValue);
    }

    @Override
    protected void synchronizeEditableState() {
        if (this.combo != null) {
            boolean listEnabled = this.isEditable() && this.isEnabled();
            this.combo.setEnabled(listEnabled);
        }
    }

    @Override
    public JComponent getObjectComponent() {
        if (this.objectPane == null) {
            this.objectPane = new JPanel(new BorderLayout());
            this.combo = new JComboBox(this.comboModel);
            this.combo.setKeySelectionManager(new ComboBoxKeyManager());
            this.combo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent ie) {
                    if (ie.getStateChange() == 1) {
                        ComboBoxEditor.this.updateModel();
                    }
                }
            });
            if (this.renderer != null) {
                this.combo.setRenderer(this.renderer);
            }
            this.objectPane.add((Component)this.combo, "Center");
            if (this.getEditorContext() != null && this.isAllowedToOpen()) {
                this.openButton = new JButton("...");
                this.objectPane.add((Component)this.openButton, "East");
                this.openButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent newE) {
                        ComboBoxEditor.this.openSelectedObject();
                    }
                });
                this.openButton.setEnabled(this.canViewItem());
            }
            this.updateView();
            this.synchronizeEditableState();
        }
        return this.objectPane;
    }

    protected boolean canViewItem() {
        EditorContext edContext = this.getEditorContext();
        return edContext != null && edContext.canEditInContext(false, this.getModelAccess().getModelClass(), this);
    }

    void openSelectedObject() {
        EditorContext editorContext = this.getEditorContext();
        Object selected = this.comboModel.getSelectedItem();
        if (editorContext != null) {
            this.openButton.setEnabled(false);
            Object result = editorContext.editInContext(selected, this.getModelAccess().getModelClass(), this);
            if (result != null && this.isEditable() && this.isEnabled()) {
                this.setViewValue(result);
                this.updateModel();
            }
            this.openButton.setEnabled(true);
        } else {
            log.warn((Object)("Cannot open " + selected + " because editorContext is not defined"));
        }
    }

    @Override
    public JComponent getEditorComponent() {
        if (this.editionPane == null) {
            this.editionPane = new JPanel(new BorderLayout());
            this.editionPane.add((Component)this.getObjectComponent(), "Center");
            this.editionPane.add((Component)this.getLabelComponent(), "West");
        }
        return this.editionPane;
    }

    void fireObjectSelectionChanged() {
        if (this.listeners != null) {
            for (ObjectSelectionListener lis : this.listeners) {
                lis.objectSelectionChanged(this);
            }
        }
    }

    @Override
    public Object getSelectedObject() {
        return this.comboModel.getSelectedItem();
    }

    @Override
    public void clearSelection() {
        this.comboModel.setSelectedItem(null);
    }

    @Override
    public void selectDefaultItem() {
        if (this.combo != null && this.comboModel.getSize() > 0) {
            this.combo.setSelectedIndex(0);
        }
    }

    @Override
    public int getSelectedObjectCount() {
        return this.comboModel.getSelectedItem() == null ? 0 : 1;
    }

    public List<Object> getSelectedObjects() {
        Object selected = this.getSelectedObject();
        return selected == null ? null : Collections.singletonList(selected);
    }

    @Override
    public boolean isMultiSelectionEnabled() {
        return false;
    }

    @Override
    public boolean canSelectObjects(List<?> toSelect) {
        return toSelect == null || toSelect.size() <= 1;
    }

    @Override
    public void selectObjects(List<?> toSelect) {
        Object newSelection = null;
        if (toSelect != null && toSelect.size() == 1) {
            newSelection = toSelect.get(0);
        }
        this.comboModel.setSelectedItem(newSelection);
    }

    @Override
    public void addObjectSelectionListener(ObjectSelectionListener lis) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ObjectSelectionListener>();
        }
        this.listeners.add(lis);
    }

    @Override
    public void removeObjectSelectionListener(ObjectSelectionListener lis) {
        if (this.listeners != null) {
            this.listeners.remove(lis);
        }
    }
}

