/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.cmp;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.sf.sfac.gui.editor.EditorContext;
import net.sf.sfac.gui.editor.EditorModificationListener;
import net.sf.sfac.gui.editor.EditorModificationSupport;
import net.sf.sfac.gui.editor.ModelAccess;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.gui.editor.access.BasicModelAccess;
import net.sf.sfac.lang.LanguageSupport;
import net.sf.sfac.setting.Settings;
import net.sf.sfac.utils.Comparison;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseObjectEditor
implements ObjectEditor {
    private static Log log = LogFactory.getLog(BaseObjectEditor.class);
    private String label;
    private ModelAccess labelAccess;
    private String description;
    private ModelAccess descriptionAccess;
    private boolean editable = true;
    private boolean enabled = true;
    private EditorContext context;
    private ModelAccess access = BasicModelAccess.INSTANCE;
    private Object editedObject;
    private Map<String, Object> properties;
    private EditorModificationSupport modificationSupport = new EditorModificationSupport(this);
    private JLabel labelComponent;

    public void edit(Object objToEdit) {
        boolean oldEnabled = this.isEnabled();
        this.editedObject = objToEdit;
        this.updateView();
        if (oldEnabled != this.isEnabled()) {
            this.synchronizeEditableState();
        }
    }

    public Object getEditedObject() {
        return this.editedObject;
    }

    public Object getModelValue() {
        return this.access.getModelValue(this.getEditedObject());
    }

    public void setModelValue(Object newModelValue) {
        this.access.setModelValue(newModelValue, this.getEditedObject());
    }

    public void setLabel(String newLabel) {
        this.label = newLabel;
        this.updateLabelText();
    }

    public String getLabel() {
        return this.label;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getLabel() + "]";
    }

    public String getTranslatedLabel() {
        String translatedLabel;
        if (this.labelAccess != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("In editor " + this + ", apply label acces " + this.labelAccess + " to value: " + this.getModelValue()));
            }
            translatedLabel = this.getEditedObject() != null ? (String)this.labelAccess.getModelValue(this.getModelValue()) : (Comparison.isDefined((String)this.label) ? LanguageSupport.getLocalizedString((String)this.label) : "---");
        } else {
            translatedLabel = LanguageSupport.getLocalizedString((String)this.label);
        }
        return translatedLabel;
    }

    public String getTranslatedDescription() {
        String translatedDescription = null;
        if (this.descriptionAccess != null) {
            translatedDescription = this.getEditedObject() != null ? (String)this.descriptionAccess.getModelValue(this.getEditedObject()) : (Comparison.isDefined((String)this.description) ? LanguageSupport.getLocalizedString((String)this.description) : "---");
        } else if (Comparison.isDefined((String)this.description)) {
            translatedDescription = LanguageSupport.getLocalizedString((String)this.description);
        }
        return translatedDescription;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
        this.updateDescriptionText();
    }

    public String getDescription() {
        return this.description;
    }

    public ModelAccess getModelAccess() {
        return this.access;
    }

    public void setModelAccess(ModelAccess newModelAccess) {
        if (newModelAccess == null) {
            throw new IllegalArgumentException("ModelAccess cannot be null");
        }
        this.access = newModelAccess;
        if (this.isEditable() && !this.access.canUpdateModel()) {
            this.setEditable(false);
        }
    }

    public ModelAccess getLabelAccess() {
        return this.labelAccess;
    }

    public void setLabelAccess(ModelAccess newLabelAccess) {
        this.labelAccess = newLabelAccess;
    }

    public void setDescriptionAccess(ModelAccess newDescriptionAccess) {
        this.descriptionAccess = newDescriptionAccess;
    }

    public ModelAccess getDescriptionAccess() {
        return this.descriptionAccess;
    }

    public void setEditorContext(EditorContext newContext) {
        if (this.context != null && newContext != null && this.context != newContext) {
            throw new IllegalStateException("Context (or parent) cannot change from " + this.context + " to " + newContext);
        }
        this.context = newContext;
    }

    public EditorContext getEditorContext() {
        return this.context;
    }

    public boolean isEditable() {
        return this.editable && this.getEditedObject() != null;
    }

    public void setEditable(boolean newEditable) {
        if (!this.access.canUpdateModel()) {
            newEditable = false;
        }
        if (this.editable != newEditable) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Editor " + this + " set editable=" + newEditable));
            }
            this.editable = newEditable;
            this.synchronizeEditableState();
        }
    }

    public boolean isEnabled() {
        return this.enabled && this.getEditedObject() != null;
    }

    public void setEnabled(boolean newEnabled) {
        if (this.enabled != newEnabled) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Editor " + this + " set enabled=" + newEnabled));
            }
            this.enabled = newEnabled;
            this.synchronizeEditableState();
        }
    }

    protected abstract void synchronizeEditableState();

    public Settings getSettings() {
        return this.context == null ? null : this.context.getSettings();
    }

    public JComponent getLabelComponent() {
        if (this.labelComponent == null && !Comparison.isEmpty((String)this.label)) {
            this.labelComponent = this.createLabelComponent();
            this.updateLabelText();
            this.updateDescriptionText();
        }
        return this.labelComponent;
    }

    protected JLabel createLabelComponent() {
        JLabel lbl = null;
        if (!Comparison.isEmpty((String)this.label)) {
            lbl = new JLabel();
        }
        return lbl;
    }

    protected void updateLabelText() {
        if (this.labelComponent != null) {
            this.labelComponent.setText(this.getTranslatedLabel());
        }
    }

    protected void updateDescriptionText() {
        if (this.labelComponent != null) {
            this.labelComponent.setToolTipText(this.getTranslatedDescription());
        }
    }

    public void setProperty(String name, Object value) {
        if (name.equals("label")) {
            this.setLabel((String)value);
        }
        if (name.equals("description")) {
            this.setDescription((String)value);
        } else {
            if (this.properties == null) {
                this.properties = new HashMap<String, Object>();
            }
            this.properties.put(name, value);
        }
    }

    public Object getProperty(String name, Object defaultValue) {
        if (name.equals("label")) {
            return this.label == null ? defaultValue : this.label;
        }
        if (name.equals("description")) {
            return this.description == null ? defaultValue : this.description;
        }
        Object propValue = this.properties == null ? null : this.properties.get(name);
        return propValue == null ? defaultValue : propValue;
    }

    public int getIntProperty(String name, int defaultValue) {
        Object value = this.getProperty(name, null);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(value.toString());
    }

    public double getDoubleProperty(String name, double defaultValue) {
        Object value = this.getProperty(name, null);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return Double.parseDouble(value.toString());
    }

    public void addEditorModificationListener(EditorModificationListener lis) {
        this.modificationSupport.addEditorModificationListener(lis);
    }

    public void removeEditorModificationListener(EditorModificationListener lis) {
        this.modificationSupport.removeEditorModificationListener(lis);
    }

    protected EditorModificationSupport getEditorModificationSupport() {
        return this.modificationSupport;
    }
}

