/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.access;

import java.lang.reflect.Method;
import net.sf.sfac.gui.editor.access.ChainableModelAccess;
import net.sf.sfac.utils.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflexionModelAccess
extends ChainableModelAccess {
    private String path;
    private Method getter;
    private Method setter;

    public ReflexionModelAccess(String fieldName, Class<?> enclosingClass, Class<?> fieldClass) {
        this.path = fieldName;
        this.getter = ReflectionUtils.getGetter(enclosingClass, (String)fieldName, fieldClass);
        this.setupSetter(fieldName, enclosingClass);
    }

    public ReflexionModelAccess(Class<?> enclosingClass, Method fieldGetter) {
        if (fieldGetter == null) {
            throw new IllegalArgumentException("Getter cannot be null");
        }
        this.getter = fieldGetter;
        this.path = ReflectionUtils.getFieldName((Method)fieldGetter);
        this.setupSetter(this.path, enclosingClass);
    }

    private void setupSetter(String attributeName, Class<?> enclosingClass) {
        this.setter = ReflectionUtils.getSetter(enclosingClass, (String)attributeName, this.getter.getReturnType(), (boolean)false);
    }

    @Override
    public Object getModelValue(Object baseObject) {
        Object editedObject = super.getModelValue(baseObject);
        if (editedObject == null) {
            return null;
        }
        try {
            Object value = this.getter.invoke(editedObject, (Object[])null);
            return value;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to invoke getter " + this.getter + " on object " + editedObject, e);
        }
    }

    @Override
    public void setModelValue(Object newModelValue, Object baseObject) {
        Object editedObject = super.getModelValue(baseObject);
        if (editedObject == null) {
            throw new NullPointerException("Unable to set value on null object");
        }
        if (this.setter == null) {
            throw new IllegalStateException("Setter is null cannot set value '" + newModelValue + "' on object " + editedObject);
        }
        try {
            this.setter.invoke(editedObject, newModelValue);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to invoke setter " + this.setter + " with value '" + newModelValue + "' on object " + editedObject, e);
        }
    }

    @Override
    public boolean canUpdateModel() {
        return this.setter != null;
    }

    @Override
    public Class<?> getThisEditedObjectClass() {
        return this.getter.getDeclaringClass();
    }

    @Override
    public Class<?> getModelClass() {
        return this.getter.getReturnType();
    }

    @Override
    public String getThisFieldPath() {
        return this.path;
    }
}

