/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor.access;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import net.sf.sfac.gui.editor.ModelAccess;
import net.sf.sfac.gui.editor.access.ChainableModelAccess;
import net.sf.sfac.utils.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedModelAccess
extends ChainableModelAccess {
    private String path;
    private Class<?> itemClass;
    private boolean listAcccess;
    private Method sizer;
    private Method getter;
    private Method setter;
    private Method adder;
    private Method remover;
    private Method switcher;

    public static boolean isIndexedGetter(Method getter) {
        Class<?> returnType = getter.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            return false;
        }
        if (List.class.isAssignableFrom(returnType)) {
            return true;
        }
        Class<?>[] params = getter.getParameterTypes();
        if (params == null || params.length != 1) {
            return false;
        }
        return params[0].equals(Integer.TYPE);
    }

    public static boolean isListGetter(Method getter) {
        if (getter.getReturnType().equals(Void.TYPE)) {
            return false;
        }
        Class<?>[] params = getter.getParameterTypes();
        if (params != null && params.length > 0) {
            return false;
        }
        return List.class.isAssignableFrom(getter.getReturnType());
    }

    public IndexedModelAccess(String fieldName, Class<?> enclosingClass) {
        this(fieldName, enclosingClass, null);
    }

    public IndexedModelAccess(String fieldName, Class<?> enclosingClass, Class<?> fieldClass) {
        Method fieldGetter = ReflectionUtils.getMethod(enclosingClass, (String)"get", (String)fieldName, null, (boolean)false, (Class[])new Class[]{Integer.TYPE});
        if (fieldGetter == null) {
            fieldGetter = ReflectionUtils.getMethod(enclosingClass, (String)"get", (String)fieldName, null, (Class[])new Class[0]);
        }
        this.setup(enclosingClass, fieldGetter, fieldName, fieldClass);
    }

    public IndexedModelAccess(Class<?> enclosingClass, Method fieldGetter) {
        this(enclosingClass, fieldGetter, null);
    }

    public IndexedModelAccess(Class<?> enclosingClass, Method fieldGetter, Class<?> fieldClass) {
        this.setup(enclosingClass, fieldGetter, ReflectionUtils.getFieldName((Method)fieldGetter), fieldClass);
    }

    public IndexedModelAccess(ModelAccess access) {
        if (!List.class.isAssignableFrom(access.getModelClass())) {
            throw new IllegalArgumentException("IndexedModelAccess needs a inner Model access returning List instances, not: " + access.getModelClass());
        }
        this.setParent(access);
        this.listAcccess = true;
    }

    private void setup(Class<?> enclosingClass, Method fieldGetter, String fieldName, Class<?> simpleItemClass) {
        if (fieldGetter == null) {
            throw new IllegalArgumentException("Getter cannot be null");
        }
        this.getter = fieldGetter;
        this.itemClass = simpleItemClass;
        this.path = fieldName;
        if (IndexedModelAccess.isListGetter(fieldGetter)) {
            this.listAcccess = true;
        } else {
            if (!IndexedModelAccess.isIndexedGetter(fieldGetter)) {
                throw new IllegalStateException("The the method " + fieldGetter + " must be indexed getter like: public Object getSomething(int index)");
            }
            if (this.itemClass == null) {
                this.itemClass = fieldGetter.getReturnType();
            }
            this.setupAccessMethods(fieldName, enclosingClass, this.itemClass);
        }
    }

    private List<Object> getList(Object baseObject) {
        List theList = null;
        Object editedObject = super.getModelValue(baseObject);
        if (editedObject != null) {
            try {
                theList = this.getter == null ? (List)editedObject : (List)this.getter.invoke(editedObject, (Object[])null);
            }
            catch (ClassCastException cce) {
                throw new IllegalStateException("Object obtained by ModelAccess is not a List", cce);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to invoke indexed getter " + this.getter + " on object " + editedObject, e);
            }
        }
        return theList;
    }

    public int getItemCount(Object baseObject) {
        if (this.listAcccess) {
            List<Object> items = this.getList(baseObject);
            return items == null ? 0 : items.size();
        }
        Object editedObject = super.getModelValue(baseObject);
        if (editedObject == null) {
            return 0;
        }
        try {
            Object value = this.sizer.invoke(editedObject, (Object[])null);
            return (Integer)value;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to invoke method " + this.sizer + " on object " + editedObject, e);
        }
    }

    public Object getItem(Object baseObject, int index) {
        if (this.listAcccess) {
            return this.getList(baseObject).get(index);
        }
        Object editedObject = super.getModelValue(baseObject);
        if (editedObject == null) {
            return null;
        }
        try {
            Object value = this.getter.invoke(editedObject, index);
            return value;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to invoke indexed getter " + this.getter + " on object " + editedObject, e);
        }
    }

    public boolean canSetItem() {
        return this.listAcccess || this.setter != null;
    }

    public void setItem(Object baseObject, int index, Object value) {
        if (this.listAcccess) {
            this.getList(baseObject).set(index, value);
        } else {
            Object editedObject = super.getModelValue(baseObject);
            if (editedObject != null) {
                try {
                    this.setter.invoke(editedObject, index, value);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to invoke indexed setter " + this.setter + " on object " + editedObject, e);
                }
            }
        }
    }

    public boolean canAddItem() {
        if (this.listAcccess) {
            return this.itemClass != null && !this.itemClass.isInterface() && !Modifier.isAbstract(this.itemClass.getModifiers());
        }
        return this.adder != null;
    }

    public void addItem(Object baseObject, int index, Object value) {
        try {
            if (value == null && this.itemClass != null) {
                value = this.itemClass.newInstance();
            }
            if (this.listAcccess) {
                this.getList(baseObject).add(index, value);
            } else {
                Object editedObject = super.getModelValue(baseObject);
                if (editedObject != null) {
                    this.adder.invoke(editedObject, index, value);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to invoke method " + this.adder + " on object " + baseObject, e);
        }
    }

    public boolean canRemoveItem() {
        if (this.listAcccess) {
            return this.canAddItem();
        }
        return this.remover != null;
    }

    public void removeItem(Object baseObject, int index) {
        if (this.listAcccess) {
            this.getList(baseObject).remove(index);
        } else {
            Object editedObject = super.getModelValue(baseObject);
            if (editedObject != null) {
                try {
                    this.remover.invoke(editedObject, index);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to invoke method " + this.remover + " on object " + editedObject, e);
                }
            }
        }
    }

    public boolean canSwitchItem() {
        return this.switcher != null || this.listAcccess;
    }

    public void switchItems(Object baseObject, int index1, int index2) {
        if (this.listAcccess) {
            List<Object> items = this.getList(baseObject);
            Object value = items.get(index1);
            items.set(index1, items.get(index2));
            items.set(index2, value);
        } else {
            Object editedObject = super.getModelValue(baseObject);
            if (editedObject != null) {
                try {
                    this.switcher.invoke(editedObject, index1, index2);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to invoke method " + this.switcher + " on object " + editedObject, e);
                }
            }
        }
    }

    private void setupAccessMethods(String attrName, Class<?> enclosingClass, Class<?> simpleItemClass) {
        this.sizer = ReflectionUtils.getMethod(enclosingClass, (String)"get", (String)attrName, (String)"Count", (Class[])new Class[0]);
        if (simpleItemClass != null) {
            this.setter = ReflectionUtils.getMethod(enclosingClass, (String)"set", (String)attrName, null, (boolean)false, (Class[])new Class[]{Integer.TYPE, simpleItemClass});
            this.adder = ReflectionUtils.getMethod(enclosingClass, (String)"add", (String)attrName, null, (boolean)false, (Class[])new Class[]{Integer.TYPE, simpleItemClass});
        }
        this.remover = ReflectionUtils.getMethod(enclosingClass, (String)"remove", (String)attrName, null, (boolean)false, (Class[])new Class[]{Integer.TYPE});
        this.switcher = ReflectionUtils.getMethod(enclosingClass, (String)"switch", (String)attrName, null, (boolean)false, (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
    }

    @Override
    public Object getModelValue(Object baseObject) {
        if (this.listAcccess) {
            return this.getList(baseObject);
        }
        return null;
    }

    @Override
    public void setModelValue(Object newModelValue, Object editedObject) {
        throw new UnsupportedOperationException("Access to model must be indexed");
    }

    @Override
    public boolean canUpdateModel() {
        if (this.listAcccess) {
            return true;
        }
        return this.setter != null || this.adder != null || this.remover != null || this.switcher != null;
    }

    @Override
    public Class<?> getThisEditedObjectClass() {
        return this.getter == null ? List.class : this.getter.getDeclaringClass();
    }

    public void setModelClass(Class<?> modelClass) {
        this.itemClass = modelClass;
    }

    @Override
    public Class<?> getModelClass() {
        return this.itemClass;
    }

    @Override
    public String getThisFieldPath() {
        return this.path;
    }
}

