/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor;

import java.awt.Component;
import net.sf.sfac.editor.Validable;
import net.sf.sfac.editor.ValidationMessage;
import net.sf.sfac.editor.ValidationReport;
import net.sf.sfac.editor.ValidationReportImpl;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.gui.editor.ValidationDialog;

public class ValidationHelper {
    public static boolean validate(ObjectEditor editor, Action act, Component parent) {
        boolean aborted = false;
        Object editedObject = editor.getEditedObject();
        if (editedObject != null && editedObject instanceof Validable) {
            Validable objToValidate = (Validable)editedObject;
            ValidationReportImpl report = new ValidationReportImpl();
            switch (act) {
                case CREATE: {
                    objToValidate.validateCreation((ValidationReport)report);
                    break;
                }
                case UPDATE: {
                    objToValidate.validateModification((ValidationReport)report);
                    break;
                }
                case DELETE: {
                    objToValidate.validateDelete((ValidationReport)report);
                }
            }
            if (report.getGlobalValidationLevel() != ValidationMessage.Level.OK) {
                aborted = ValidationDialog.showReportDialog((ValidationReport)report, parent);
            }
        }
        return aborted;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        CREATE,
        UPDATE,
        DELETE;

    }
}

