/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.sfac.editor.ValidationMessage;
import net.sf.sfac.editor.ValidationReport;
import net.sf.sfac.gui.framework.SharedResources;
import net.sf.sfac.lang.LanguageSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidationDialog
extends JDialog {
    private static Log log = LogFactory.getLog(ValidationDialog.class);
    private ValidationReport report;
    private boolean aborted;

    public static boolean showReportDialog(ValidationReport report, Component parent) {
        ValidationDialog dial = new ValidationDialog(parent, report);
        dial.setVisible(true);
        return dial.isAborted();
    }

    public ValidationDialog(Component parent, ValidationReport theReport) {
        super(JOptionPane.getFrameForComponent(parent));
        this.setModal(true);
        this.report = theReport;
        this.setTitle();
        this.buildGui();
        this.aborted = this.report.getGlobalValidationLevel() == ValidationMessage.Level.ERROR;
        this.setBounds(parent);
    }

    private void setBounds(Component c) {
        this.pack();
        Component root = null;
        if (c != null) {
            if (c instanceof Window || c instanceof Applet) {
                root = (Container)c;
            } else {
                for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof Window) && !(parent instanceof Applet)) continue;
                    root = parent;
                    break;
                }
            }
        }
        if (root != null && root.isShowing()) {
            Point rootLocation = root.getLocationOnScreen();
            Dimension rootSize = root.getSize();
            int targetX = rootLocation.x + (rootSize.width - this.getWidth()) / 2;
            int targetY = rootLocation.y + (rootSize.height - this.getHeight()) / 2;
            this.setLocation(targetX, targetY);
        } else {
            log.warn((Object)"Cannot setBounds relative to a non-showing component");
        }
    }

    private void buildGui() {
        int i;
        JPanel pane = new JPanel(new GridBagLayout());
        pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        List validationMessages = this.report.getValidationMessages();
        int len = validationMessages.size();
        for (i = 0; i < len; ++i) {
            ValidationMessage msg = (ValidationMessage)validationMessages.get(i);
            JLabel label = new JLabel(msg.getText(), this.getIcon(msg), 0);
            pane.add((Component)label, new GridBagConstraints(0, i, 2, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 0, 0), 0, 0));
        }
        this.setContentPane(pane);
        if (this.report.getGlobalValidationLevel() == ValidationMessage.Level.ERROR) {
            JButton okButton = new JButton(LanguageSupport.getOptionalLocalizedString((String)"OK", (String)"Ok"));
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent newE) {
                    ValidationDialog.this.abort();
                }
            });
            pane.add((Component)okButton, new GridBagConstraints(0, i, 2, 1, 0.0, 0.0, 10, 0, new Insets(8, 0, 0, 0), 0, 0));
        } else {
            JButton continueButton = new JButton(LanguageSupport.getOptionalLocalizedString((String)"CONTINUE", (String)"Continue"));
            continueButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent newE) {
                    ValidationDialog.this.dispose();
                }
            });
            pane.add((Component)continueButton, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 0, 0, 4), 0, 0));
            JButton abortButton = new JButton(LanguageSupport.getOptionalLocalizedString((String)"ABORT", (String)"Abort"));
            abortButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent newE) {
                    ValidationDialog.this.abort();
                }
            });
            pane.add((Component)abortButton, new GridBagConstraints(1, i, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 4, 0, 0), 0, 0));
        }
        this.setContentPane(pane);
    }

    void abort() {
        this.aborted = true;
        this.dispose();
    }

    public boolean isAborted() {
        return this.aborted;
    }

    private void setTitle() {
        String titleKey;
        switch (this.report.getGlobalValidationLevel()) {
            case ERROR: {
                titleKey = "VALIDATION_ERROR";
                break;
            }
            case WARNING: {
                titleKey = "VALIDATION_WARNING";
                break;
            }
            case INFO: {
                titleKey = "VALIDATION_INFO";
                break;
            }
            default: {
                throw new IllegalStateException("Cannot show valiadation dialog for level: " + this.report.getGlobalValidationLevel());
            }
        }
        this.setTitle(LanguageSupport.getLocalizedString((String)titleKey));
    }

    private Icon getIcon(ValidationMessage msg) {
        switch (msg.getLevel()) {
            case ERROR: {
                return SharedResources.getIcon("error.gif");
            }
            case WARNING: {
                return SharedResources.getIcon("warning.gif");
            }
            case INFO: {
                return SharedResources.getIcon("info.gif");
            }
        }
        throw new IllegalStateException("Cannot show valiadation dialog for level: " + this.report.getGlobalValidationLevel());
    }
}

