/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.sf.sfac.gui.ExceptionDialog;
import net.sf.sfac.gui.cmp.SizedDialog;
import net.sf.sfac.gui.editor.CommitableObject;
import net.sf.sfac.gui.editor.EditorContextImpl;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.gui.editor.cmp.GenericObjectEditor;
import net.sf.sfac.lang.LanguageSupport;
import net.sf.sfac.setting.Settings;

public class SimpleObjectEditionController {
    private String controllerId;
    private Settings setts;
    private Object objectToEdit;
    private SizedDialog editionDialog;
    private ObjectEditor settingsEditor;
    private JButton okButton;
    private JButton cancelButton;

    public SimpleObjectEditionController(String id, Settings settngs, Object toEdit) {
        if (id == null) {
            throw new IllegalArgumentException("The given id cannot be null");
        }
        if (settngs == null) {
            throw new IllegalArgumentException("The given Settings cannot be null");
        }
        if (toEdit == null) {
            throw new IllegalArgumentException("The given object to edit cannot be null");
        }
        this.controllerId = id;
        this.setts = settngs;
        this.objectToEdit = toEdit;
    }

    public void showSettingEditionDialog(Component parent) {
        this.editionDialog = new SizedDialog(parent, this.setts, "dial." + this.controllerId);
        this.editionDialog.setTitle(LanguageSupport.getLocalizedString((String)"dial_settings_title"));
        this.buildGui(this.editionDialog.getContentPane());
        this.editionDialog.setDefaultCloseOperation(2);
        this.editionDialog.setLocationRelativeTo(parent, 50, 50);
        this.editionDialog.setVisible(true);
    }

    private void buildGui(Container contentPane) {
        this.settingsEditor = new GenericObjectEditor(this.objectToEdit.getClass());
        new EditorContextImpl(this.setts, this.settingsEditor);
        this.settingsEditor.edit(this.objectToEdit);
        contentPane.add((Component)this.settingsEditor.getEditorComponent(), "Center");
        JPanel buttonPane = new JPanel();
        this.okButton = new JButton(LanguageSupport.getLocalizedString((String)"OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent newE) {
                SimpleObjectEditionController.this.commitAndClose();
            }
        });
        this.editionDialog.getRootPane().setDefaultButton(this.okButton);
        buttonPane.add(this.okButton);
        if (this.objectToEdit instanceof CommitableObject) {
            this.cancelButton = new JButton(LanguageSupport.getLocalizedString((String)"CANCEL"));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent newE) {
                    SimpleObjectEditionController.this.cancelAndClose();
                }
            });
            buttonPane.add(this.cancelButton);
        }
        contentPane.add((Component)buttonPane, "South");
    }

    void commitAndClose() {
        try {
            this.settingsEditor.updateModel();
            if (this.objectToEdit instanceof CommitableObject) {
                ((CommitableObject)this.objectToEdit).commitChanges();
            }
            this.editionDialog.dispose();
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog(this.editionDialog, "setting_error", "bad_setting", e);
        }
    }

    void cancelAndClose() {
        if (this.objectToEdit instanceof CommitableObject) {
            ((CommitableObject)this.objectToEdit).rollbackChanges();
        }
        this.editionDialog.dispose();
    }
}

