/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.sf.sfac.gui.cmp.SizedDialog;
import net.sf.sfac.gui.editor.EditorContext;
import net.sf.sfac.gui.editor.EditorFactory;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.gui.editor.cmp.GenericObjectEditor;
import net.sf.sfac.lang.LanguageSupport;
import net.sf.sfac.setting.Settings;
import net.sf.sfac.utils.Comparison;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorOptionsDialog
extends SizedDialog
implements EditorContext {
    private Component parent;
    private Object[] availableOptions = new Object[]{"OK", "CANCEL"};
    private Object defaultOption = "OK";
    private Object choosenOption;
    private GenericObjectEditor editor;

    public EditorOptionsDialog(Component owner) {
        this(owner, null, "options.dialog");
    }

    public EditorOptionsDialog(Component owner, Settings sett, String dialogBaseId) {
        super(owner, sett, dialogBaseId);
        this.setModal(true);
        this.parent = owner;
    }

    public void setAvailableOptions(Object[] options) {
        this.availableOptions = options;
        this.defaultOption = options[0];
    }

    public void setDefaultOption(Object newDefaultOption) {
        this.defaultOption = newDefaultOption;
    }

    public Object showAndEditObject(Object toEdit) {
        this.choosenOption = null;
        this.editor = new GenericObjectEditor(toEdit.getClass());
        this.editor.edit(toEdit);
        this.buildGui();
        if (this.getSettings() == null) {
            this.pack();
            this.setLocationRelativeTo(this.parent);
        }
        this.setVisible(true);
        return this.choosenOption;
    }

    private void buildGui() {
        JPanel contentPane = new JPanel(new BorderLayout());
        this.setContentPane(contentPane);
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.add((Component)this.editor.getEditorComponent(), "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        int len = this.availableOptions.length;
        for (int i = 0; i < len; ++i) {
            final int optionIndex = i;
            JButton but = new JButton(this.getLabelForOption(i));
            buttonPane.add(but);
            if (Comparison.equals((Object)this.defaultOption, (Object)this.availableOptions[i])) {
                this.getRootPane().setDefaultButton(but);
            }
            but.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EditorOptionsDialog.this.closeDialog(optionIndex);
                }
            });
        }
        contentPane.add((Component)buttonPane, "South");
    }

    private String getLabelForOption(int i) {
        String defaultValue;
        Object option = this.availableOptions[i];
        String key = defaultValue = option.toString();
        if (option instanceof Enum) {
            key = option.getClass().getSimpleName() + "." + ((Enum)option).name();
        }
        return LanguageSupport.getOptionalLocalizedString((String)key, (String)defaultValue);
    }

    void closeDialog(int optionIndex) {
        this.editor.updateModel();
        this.choosenOption = this.availableOptions[optionIndex];
        this.dispose();
    }

    @Override
    public boolean canEditInContext(boolean create, Class<?> objectClass, ObjectEditor source) {
        return false;
    }

    @Override
    public <T> T editInContext(T obj, Class<T> objectClass, ObjectEditor source) {
        return null;
    }

    public void editorModified(boolean modified, ObjectEditor source) {
    }

    @Override
    public Object getContextObject(String objectKey) {
        return null;
    }

    @Override
    public EditorFactory getEditorFactory() {
        return null;
    }

    @Override
    public Collection<ObjectEditor> getEditors() {
        if (this.editor == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(this.editor);
    }
}

