/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import net.sf.sfac.gui.editor.EditorModificationEvent;
import net.sf.sfac.gui.editor.EditorModificationListener;
import net.sf.sfac.gui.editor.ObjectEditor;

public class EditorModificationSupport {
    private ObjectEditor source;
    private boolean enableEvents;
    private List<EditorModificationListener> listeners;
    private EditorModificationListener listenerForSubEditors;
    private ListDataListener listModelListener;
    private TableModelListener tableModelListener;

    public EditorModificationSupport(ObjectEditor newSource) {
        if (newSource == null) {
            throw new IllegalArgumentException("Source cannot be null");
        }
        this.source = newSource;
        this.enableEvents = true;
    }

    public void addEditorModificationListener(EditorModificationListener lis) {
        if (lis == null) {
            throw new IllegalArgumentException("Added litener cannot be null");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<EditorModificationListener>();
        }
        this.listeners.add(lis);
    }

    public void removeEditorModificationListener(EditorModificationListener lis) {
        if (this.listeners != null) {
            this.listeners.remove(lis);
        }
    }

    public void fireEditorModified(Object oldEditedValue) {
        if (this.enableEvents && this.listeners != null && this.listeners.size() > 0) {
            EditorModificationEvent eme = new EditorModificationEvent(this.source, oldEditedValue);
            for (EditorModificationListener lis : this.listeners) {
                lis.editorModified(eme);
            }
        }
    }

    public boolean getEnableEvents() {
        return this.enableEvents;
    }

    public void setEnableEvents(boolean newEnableEvents) {
        this.enableEvents = newEnableEvents;
    }

    public EditorModificationListener getListenerForSubEditors() {
        if (this.listenerForSubEditors == null) {
            this.listenerForSubEditors = new EditorModificationListener(){

                public void editorModified(EditorModificationEvent eme) {
                    EditorModificationSupport.this.fireSubEditorModified(eme);
                }
            };
        }
        return this.listenerForSubEditors;
    }

    public ListDataListener getListenerForListModel() {
        if (this.listModelListener == null) {
            this.listModelListener = new ListDataListener(){

                public void intervalRemoved(ListDataEvent e) {
                    EditorModificationSupport.this.fireEditorModified(e);
                }

                public void intervalAdded(ListDataEvent e) {
                    EditorModificationSupport.this.fireEditorModified(e);
                }

                public void contentsChanged(ListDataEvent e) {
                    EditorModificationSupport.this.fireEditorModified(e);
                }
            };
        }
        return this.listModelListener;
    }

    public TableModelListener getListenerForTableModel() {
        if (this.tableModelListener == null) {
            this.tableModelListener = new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    EditorModificationSupport.this.fireEditorModified(e);
                }
            };
        }
        return this.tableModelListener;
    }

    void fireSubEditorModified(EditorModificationEvent subEme) {
        if (this.enableEvents && this.listeners != null && this.listeners.size() > 0) {
            EditorModificationEvent eme = new EditorModificationEvent(this.source, subEme);
            for (EditorModificationListener lis : this.listeners) {
                lis.editorModified(eme);
            }
        }
    }
}

