/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor;

import java.util.ArrayList;
import java.util.List;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.utils.Comparison;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorModificationEvent {
    private ObjectEditor root;
    private Object oldValue;
    private EditorModificationEvent sub;

    public EditorModificationEvent(ObjectEditor singleEditor, Object oldEditedValue) {
        this.root = singleEditor;
        this.oldValue = oldEditedValue;
    }

    public EditorModificationEvent(ObjectEditor rootEditor, EditorModificationEvent subEvent) {
        this.root = rootEditor;
        this.sub = subEvent;
    }

    public ObjectEditor getRootEditor() {
        return this.root;
    }

    public ObjectEditor getLeafEditor() {
        return this.sub == null ? this.root : this.sub.getLeafEditor();
    }

    public Object getNewValue() {
        return this.sub == null ? this.root.getModelAccess().getModelValue(this.root.getEditedObject()) : this.sub.getNewValue();
    }

    public Object getOldValue() {
        return this.sub == null ? this.oldValue : this.sub.getOldValue();
    }

    public List<ObjectEditor> getEditorPath() {
        List<Object> subList = this.sub == null ? new ArrayList() : this.sub.getEditorPath();
        subList.add(0, this.root);
        return subList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[");
        sb.append(this.getValuePath());
        sb.append(this.getLeafEvent().oldValue);
        sb.append("]");
        return sb.toString();
    }

    private EditorModificationEvent getLeafEvent() {
        if (this.sub == null) {
            return this;
        }
        return this.sub.getLeafEvent();
    }

    public String getValuePath() {
        StringBuilder sb = new StringBuilder();
        EditorModificationEvent ev = this;
        while (ev != null) {
            String path = ev.root.getModelAccess().getFieldPath();
            if (Comparison.isDefined((String)path)) {
                if (sb.length() > 0) {
                    sb.append(".");
                }
                sb.append(path);
            }
            ev = ev.sub;
        }
        return sb.toString();
    }
}

