/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor;

import java.awt.Dimension;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.sfac.editor.EditorConfig;
import net.sf.sfac.gui.editor.EditorConfigHelper;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.gui.editor.cmp.BooleanEditor;
import net.sf.sfac.gui.editor.cmp.DateEditor;
import net.sf.sfac.gui.editor.cmp.DimensionEditor;
import net.sf.sfac.gui.editor.cmp.EnumEditor;
import net.sf.sfac.gui.editor.cmp.FileEditor;
import net.sf.sfac.gui.editor.cmp.GenericObjectEditor;
import net.sf.sfac.gui.editor.cmp.ListObjectEditor;
import net.sf.sfac.gui.editor.cmp.NumberEditor;
import net.sf.sfac.gui.editor.cmp.StringEditor;
import net.sf.sfac.utils.Comparison;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.misc.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorFactory {
    private static Log log = LogFactory.getLog(EditorFactory.class);
    public static final String FACTORY_CLASS_NAME = "editor.factory.class";
    private static EditorFactory instance;
    private Map<String, Class<?>> editorClasses = new HashMap();

    public static Class<?> getEditorClass(EditorConfig annotation) {
        Class<?> clazz = null;
        String className = annotation.editor();
        if (Comparison.isDefined((String)className) && !"<[undefined]>".equals(className)) {
            try {
                return Class.forName(className);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate class <" + className + ">", e);
            }
        }
        return clazz;
    }

    public static boolean containsEditorAnnotations(Class<?> editedClass) {
        if (editedClass.isAnnotationPresent(EditorConfig.class)) {
            return true;
        }
        Method[] methods = editedClass.getDeclaredMethods();
        int len = methods.length;
        for (int i = 0; i < len; ++i) {
            if (!methods[i].isAnnotationPresent(EditorConfig.class)) continue;
            return true;
        }
        return false;
    }

    public static synchronized EditorFactory getInstance() {
        if (instance == null && (instance = EditorFactory.createInstanceWithSPI()) == null && (instance = EditorFactory.createInstanceWithSystemProperty()) == null) {
            instance = new EditorFactory();
            log.info((Object)("Use default EditorFactory: " + instance.getClass().getName()));
        }
        return instance;
    }

    private static EditorFactory createInstanceWithSPI() {
        EditorFactory fact = null;
        Class<EditorFactory> thisClass = EditorFactory.class;
        Iterator it = Service.providers(thisClass, (ClassLoader)thisClass.getClassLoader());
        if (it.hasNext()) {
            fact = (EditorFactory)it.next();
            log.info((Object)("Use EditorFactory provided with SPI: " + fact.getClass().getName()));
            if (it.hasNext()) {
                log.warn((Object)("Several implementation of EditorFactory are provided with SPI, ignored: " + it.next().getClass().getName() + " ..."));
            }
        }
        return fact;
    }

    private static EditorFactory createInstanceWithSystemProperty() {
        EditorFactory fact = null;
        String instanceClass = System.getProperty(FACTORY_CLASS_NAME);
        if (instanceClass != null) {
            try {
                fact = (EditorFactory)Class.forName(instanceClass).newInstance();
                log.info((Object)("Use EditorFactory provided with System property: " + fact.getClass().getName()));
            }
            catch (Exception e) {
                log.error((Object)("Unable to instantiate EditorFactory of class " + instanceClass), (Throwable)e);
            }
        }
        return fact;
    }

    protected EditorFactory() {
        this.addEditorMapping(String.class, StringEditor.class);
        this.addEditorMapping(Boolean.class, BooleanEditor.class);
        this.addEditorMapping(Boolean.TYPE, BooleanEditor.class);
        this.addEditorMapping(Integer.TYPE, NumberEditor.class);
        this.addEditorMapping(Long.TYPE, NumberEditor.class);
        this.addEditorMapping(Double.TYPE, NumberEditor.class);
        this.addEditorMapping(Float.TYPE, NumberEditor.class);
        this.addEditorMapping(Short.TYPE, NumberEditor.class);
        this.addEditorMapping(Character.TYPE, NumberEditor.class);
        this.addEditorMapping(Byte.TYPE, NumberEditor.class);
        this.addEditorMapping(File.class, FileEditor.class);
        this.addEditorMapping(Date.class, DateEditor.class);
        this.addEditorMapping(Dimension.class, DimensionEditor.class);
    }

    public void addEditorMapping(Class<?> objectClass, Class<?> editorClass) {
        this.editorClasses.put(objectClass.getName(), editorClass);
    }

    public void addEditorMapping(String objectClassName, Class<?> editorClass) {
        this.editorClasses.put(objectClassName, editorClass);
    }

    public ObjectEditor createEditor(Class<?> editedObjectClass) {
        return this.createEditor(editedObjectClass, GenericObjectEditor.class);
    }

    public ObjectEditor createEditor(Class<?> editedObjectClass, Class<?> defaultEditorClass) {
        ObjectEditor editor;
        if (editedObjectClass == null) {
            throw new NullPointerException("Cannot create an editor for a null class");
        }
        Class<?> editorClass = this.getEditorClass(editedObjectClass);
        if (editorClass == null) {
            editorClass = defaultEditorClass;
        }
        try {
            log.info((Object)("Creating editor <" + editorClass.getName() + "> for objects of " + editedObjectClass));
            editor = (ObjectEditor)editorClass.newInstance();
            editor.setProperty("modelClass", editedObjectClass);
            EditorConfig editorClassAnnotation = editedObjectClass.getAnnotation(EditorConfig.class);
            EditorConfigHelper.setProperties(editor, editorClassAnnotation, editedObjectClass.getSimpleName());
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate editor " + editorClass, e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create editor for " + editedObjectClass + " --> editor = " + editor));
        }
        return editor;
    }

    protected Class<?> getEditorClass(Class<?> editedObjectClass) {
        Class<?> editorClass = null;
        EditorConfig editorClassAnnotation = editedObjectClass.getAnnotation(EditorConfig.class);
        if (editorClassAnnotation != null) {
            editorClass = EditorFactory.getEditorClass(editorClassAnnotation);
        }
        if (editorClass == null) {
            editorClass = this.getEditorClassForClass(editedObjectClass);
        }
        return editorClass;
    }

    public Class<?> getEditorClassForClass(Class<?> classOfObjectToEdit) {
        if (classOfObjectToEdit == null) {
            throw new NullPointerException("Cannot create an editor for a null class");
        }
        Class<?> editorClass = this.getEditorClassForClassName(classOfObjectToEdit.getName());
        if (editorClass == null) {
            editorClass = this.getEditorClassByClassType(classOfObjectToEdit);
        }
        return editorClass;
    }

    protected Class<?> getEditorClassForClassName(String classNameOfObjectToEdit) {
        return this.editorClasses.get(classNameOfObjectToEdit);
    }

    protected Class<?> getEditorClassByClassType(Class<?> classOfObjectToEdit) {
        Class editorClass = null;
        if (classOfObjectToEdit.isEnum()) {
            editorClass = EnumEditor.class;
        }
        if (editorClass == null && Number.class.isAssignableFrom(classOfObjectToEdit)) {
            editorClass = NumberEditor.class;
        }
        if (editorClass == null && List.class.isAssignableFrom(classOfObjectToEdit)) {
            editorClass = ListObjectEditor.class;
        }
        return editorClass;
    }
}

