/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.sfac.gui.editor.EditorContext;
import net.sf.sfac.gui.editor.EditorFactory;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.setting.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorContextImpl
implements EditorContext {
    public EditorFactory factory;
    public Settings sett;
    public Map<String, Object> contextObjects;
    public ObjectEditor rootEditor;

    public EditorContextImpl(Settings newSett) {
        this.sett = newSett;
    }

    public EditorContextImpl(Settings newSett, ObjectEditor newRootEditor) {
        this.sett = newSett;
        this.rootEditor = newRootEditor;
    }

    public EditorContextImpl(Settings newSett, EditorFactory newFactory, ObjectEditor newRootEditor) {
        this.factory = newFactory;
        this.sett = newSett;
        this.setRootEditor(newRootEditor);
    }

    public void setRootEditor(ObjectEditor newRootEditor) {
        if (this.rootEditor != null) {
            this.rootEditor.setEditorContext(null);
        }
        this.rootEditor = newRootEditor;
        if (this.rootEditor != null) {
            this.rootEditor.setEditorContext(this);
        }
    }

    public ObjectEditor getRootEditor() {
        return this.rootEditor;
    }

    @Override
    public Collection<ObjectEditor> getEditors() {
        if (this.rootEditor == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(this.rootEditor);
    }

    @Override
    public boolean canEditInContext(boolean create, Class<?> objectClass, ObjectEditor source) {
        return false;
    }

    @Override
    public <T> T editInContext(T obj, Class<T> objectClass, ObjectEditor source) {
        throw new UnsupportedOperationException("editInContext is not supported in EditorContextImpl");
    }

    @Override
    public EditorFactory getEditorFactory() {
        return this.factory;
    }

    @Override
    public Settings getSettings() {
        return this.sett;
    }

    public void setSettings(Settings newSett) {
        this.sett = newSett;
    }

    public void setFactory(EditorFactory newFactory) {
        this.factory = newFactory;
    }

    @Override
    public Object getContextObject(String objectKey) {
        if (this.contextObjects == null) {
            return null;
        }
        return this.contextObjects.get(objectKey);
    }

    public void putContextObjects(String key, Object value) {
        if (this.contextObjects == null) {
            this.contextObjects = new HashMap<String, Object>();
        }
        this.contextObjects.put(key, value);
    }
}

