/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.editor;

import java.lang.reflect.Method;
import net.sf.sfac.editor.EditorConfig;
import net.sf.sfac.gui.editor.ObjectEditor;
import net.sf.sfac.gui.editor.access.ReflexionModelAccess;
import net.sf.sfac.utils.Comparison;
import net.sf.sfac.utils.ReflectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EditorConfigHelper {
    private static Log log = LogFactory.getLog(EditorConfigHelper.class);

    public static void setProperties(ObjectEditor editor, EditorConfig config, String defaultName) {
        if (config != null) {
            String tab;
            int index;
            String descriptionAccess;
            String labelAccess;
            String list;
            String type;
            String label = config.label();
            if (label.equals("<[undefined]>")) {
                editor.setProperty("label", defaultName);
            } else {
                editor.setProperty("label", label);
            }
            String description = config.description();
            if (!description.equals("<[undefined]>")) {
                editor.setProperty("description", description);
            }
            if (!(type = config.type()).equals("<[undefined]>")) {
                editor.setProperty("type", type);
            }
            if (!(list = config.list()).equals("<[undefined]>")) {
                editor.setProperty("list", list);
            }
            if (!(labelAccess = config.labelAccess()).equals("<[undefined]>")) {
                EditorConfigHelper.setupAccess(editor, labelAccess, true);
                editor.setProperty("labelAccess", labelAccess);
            }
            if (!(descriptionAccess = config.descriptionAccess()).equals("<[undefined]>")) {
                EditorConfigHelper.setupAccess(editor, descriptionAccess, false);
                editor.setProperty("descriptionAccess", descriptionAccess);
            }
            if ((index = config.index()) != -1) {
                editor.setProperty("index", index);
            }
            if (!(tab = config.tab()).equals("<[undefined]>")) {
                editor.setProperty("tab", tab);
            }
            String[] properties = config.properties();
            int len = properties.length;
            for (int i = 0; i < len; i += 2) {
                editor.setProperty(properties[i], EditorConfigHelper.getConvertedPropertyValue(properties[i], properties[i + 1]));
            }
        }
    }

    private static Object getConvertedPropertyValue(String key, String value) {
        if ("fill".equals(key)) {
            return new Integer(value);
        }
        if ("weightx".equals(key)) {
            return new Double(value);
        }
        if ("weighty".equals(key)) {
            return new Double(value);
        }
        return value;
    }

    private static void setupAccess(ObjectEditor editor, String access, boolean forLabel) {
        if (access.equals("<[undefined]>") || Comparison.isEmpty((String)access)) {
            if (forLabel) {
                editor.setLabelAccess(null);
            } else {
                editor.setDescriptionAccess(null);
            }
        } else {
            Class enclosingClass = editor.getModelAccess().getEditedObjectClass();
            Method getter = ReflectionUtils.getGetter(enclosingClass, (String)access, String.class, (boolean)false);
            if (getter == null) {
                enclosingClass = editor.getModelAccess().getModelClass();
                getter = ReflectionUtils.getGetter((Class)enclosingClass, (String)access, String.class, (boolean)false);
            }
            if (getter == null && (enclosingClass = (Class)editor.getProperty("modelClass", null)) != null) {
                getter = ReflectionUtils.getGetter((Class)enclosingClass, (String)access, String.class, (boolean)false);
            }
            if (getter != null) {
                if (forLabel) {
                    editor.setLabelAccess(new ReflexionModelAccess(enclosingClass, getter));
                } else {
                    editor.setDescriptionAccess(new ReflexionModelAccess(enclosingClass, getter));
                }
            } else {
                log.warn((Object)("Getter for " + (forLabel ? "label" : "description") + " property '" + access + "' not found in " + enclosingClass + " (editor = " + editor + ")"));
            }
        }
    }
}

