/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.cmp;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import net.sf.sfac.setting.Settings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SizedDialog
extends JDialog {
    private static Log log = LogFactory.getLog(SizedDialog.class);
    private static final String DIALOG_BOUNDS_KEY = ".bounds";
    private static final Rectangle STATIC_DEFAULT_BOUNDS = new Rectangle(20, 20, 850, 650);
    private Settings setts;
    private String dialogId;
    private Rectangle defaultBounds;
    private LocationType locType;

    public SizedDialog(Component owner, Settings sett, String dialogBaseId) {
        super(JOptionPane.getFrameForComponent(owner));
        this.dialogId = dialogBaseId;
        this.init(sett);
    }

    public SizedDialog(Dialog owner, Settings sett, String dialogBaseId) {
        super(owner);
        this.dialogId = dialogBaseId;
        this.init(sett);
    }

    public Settings getSettings() {
        return this.setts;
    }

    public LocationType getLocationType() {
        return this.locType;
    }

    public void setLocationType(LocationType newLocType) {
        this.locType = newLocType;
    }

    public Rectangle getDefaultBounds() {
        return this.defaultBounds == null ? STATIC_DEFAULT_BOUNDS : this.defaultBounds;
    }

    public void setDefaultBounds(Rectangle newDefaultBounds) {
        this.defaultBounds = newDefaultBounds;
    }

    public void setDefaultLocation(LocationType newLocType, Rectangle newDefaultBounds) {
        this.locType = newLocType;
        this.defaultBounds = newDefaultBounds;
    }

    public void setLocationRelativeTo(Component c, int spaceX, int spaceY) {
        Container root = this.getRootContainer(c);
        if (root != null && root.isShowing()) {
            Point targetLocation = root.getLocationOnScreen();
            targetLocation.x += spaceX;
            targetLocation.y += spaceY;
            Dimension screenSize = this.getToolkit().getScreenSize();
            Rectangle windowBounds = this.getBounds();
            if (targetLocation.x + windowBounds.width > screenSize.width || targetLocation.y + windowBounds.height > screenSize.height) {
                targetLocation = new Point(0, 0);
            }
            this.setLocation(targetLocation);
        } else {
            this.setLocation(new Point(10, 10));
            log.warn((Object)"Cannot locate relative to a non-showing component");
        }
    }

    private Container getRootContainer(Component c) {
        Container root = null;
        if (c != null) {
            if (c instanceof Window || c instanceof Applet) {
                root = (Container)c;
            } else {
                for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof Window) && !(parent instanceof Applet)) continue;
                    root = parent;
                    break;
                }
            }
        }
        return root;
    }

    private void init(Settings sett) {
        this.setts = sett;
        if (this.setts != null) {
            this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent e) {
                    SizedDialog.this.storeDialogBounds();
                }

                public void componentMoved(ComponentEvent e) {
                    SizedDialog.this.storeDialogBounds();
                }
            });
        }
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent he) {
                long flags = he.getChangeFlags();
                if ((flags & 2L) != 0L) {
                    SizedDialog.this.initDialogBounds();
                }
            }
        });
    }

    protected String getKeyPrefix() {
        return this.dialogId;
    }

    void initDialogBounds() {
        Rectangle rect = this.getDefaultBounds();
        if (this.setts != null) {
            rect = this.setts.getRectangleProperty(this.getKeyPrefix() + DIALOG_BOUNDS_KEY, rect);
        }
        if (this.locType == LocationType.ABSOLUTE) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set absolute dialog bounds to: " + rect));
            }
            this.setBounds(rect);
        } else {
            Dimension size = new Dimension(rect.width, rect.height);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set dialog size to: " + size + " and position relative to " + this.getOwner()));
            }
            this.setSize(size);
            this.setLocationRelativeTo(this.getOwner(), rect.x, rect.y);
        }
    }

    void storeDialogBounds() {
        Rectangle bounds = this.getBounds();
        if (this.locType == LocationType.RELATIVE) {
            Container root = this.getRootContainer(this.getOwner());
            if (root != null && root.isShowing()) {
                Point rootLocation = root.getLocationOnScreen();
                bounds.x -= rootLocation.x;
                bounds.y -= rootLocation.y;
            } else {
                Rectangle defBounds = this.getDefaultBounds();
                bounds.setLocation(defBounds.x, defBounds.y);
            }
        }
        this.setts.setRectangleProperty(this.getKeyPrefix() + DIALOG_BOUNDS_KEY, bounds);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LocationType {
        ABSOLUTE,
        RELATIVE;

    }
}

