/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.cmp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import net.sf.sfac.setting.Settings;

public class RollOverSplitPane
extends JSplitPane {
    Settings sett;
    String dividerSettingKey;

    public RollOverSplitPane() {
        this(1, false, null, null);
    }

    public RollOverSplitPane(int splitOrientation) {
        this(splitOrientation, false, null, null);
    }

    public RollOverSplitPane(int splitOrientation, boolean splitContinuousLayout) {
        this(splitOrientation, splitContinuousLayout, null, null);
    }

    public RollOverSplitPane(int splitOrientation, Component leftCmp, Component rightCmp) {
        this(splitOrientation, false, leftCmp, rightCmp);
    }

    public RollOverSplitPane(int splitOrientation, boolean splitContinuousLayout, Component leftCmp, Component rightCmp) {
        super(splitOrientation, splitContinuousLayout, leftCmp, rightCmp);
        this.setBorder(null);
    }

    public void useSettings(Settings s, String baseKey, int defaultDividerLocation) {
        this.sett = s;
        this.dividerSettingKey = baseKey + ".dividerLocation";
        if (this.sett != null) {
            int dividerLocation = this.sett.getIntProperty(this.dividerSettingKey, defaultDividerLocation);
            this.setDividerLocation(dividerLocation);
            this.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    RollOverSplitPane.this.sett.setIntProperty(RollOverSplitPane.this.dividerSettingKey, RollOverSplitPane.this.getDividerLocation());
                }
            });
        } else {
            this.setDividerLocation(defaultDividerLocation);
        }
    }

    public void updateUI() {
        this.setUI(new RollOverSplitPaneUI());
        this.setBorder(null);
        this.revalidate();
    }

    static class RollOverSplitPaneDivider
    extends BasicSplitPaneDivider {
        boolean isRollOver;

        RollOverSplitPaneDivider(BasicSplitPaneUI ui) {
            super(ui);
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent e) {
                    RollOverSplitPaneDivider.this.isRollOver = true;
                    RollOverSplitPaneDivider.this.repaint();
                }

                public void mouseExited(MouseEvent e) {
                    RollOverSplitPaneDivider.this.isRollOver = false;
                    RollOverSplitPaneDivider.this.repaint();
                }
            });
        }

        public void setBorder(Border border) {
        }

        public void paint(Graphics g) {
            if (this.isRollOver) {
                int x = this.getWidth() / 2;
                int height = this.getHeight();
                g.setColor(Color.gray);
                g.drawLine(x - 1, 0, x - 1, height);
                g.drawLine(x + 1, 0, x + 1, height);
                g.setColor(Color.white);
                g.drawLine(x, 0, x, height);
            }
        }
    }

    static class RollOverSplitPaneUI
    extends BasicSplitPaneUI {
        RollOverSplitPaneUI() {
        }

        public BasicSplitPaneDivider createDefaultDivider() {
            return new RollOverSplitPaneDivider(this);
        }
    }
}

