/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.cmp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class PartialLineBorder
extends AbstractBorder {
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    protected Color lineColor;
    protected int linePart;
    protected int lineThickness;
    protected int inset;

    public PartialLineBorder(Color color, int paintedPart) {
        this(color, paintedPart, 0, 1);
    }

    public PartialLineBorder(Color color, int paintedPart, int borderInset) {
        this(color, paintedPart, borderInset, 1);
    }

    public PartialLineBorder(Color color, int paintedPart, int borderInset, int thickness) {
        this.lineColor = color;
        this.linePart = paintedPart;
        this.inset = borderInset;
        this.lineThickness = thickness;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.lineColor);
        for (int i = 0; i < this.lineThickness; ++i) {
            int startX = x + i;
            int endX = x + width - 2 * i - 1;
            int startY = y + i;
            int endY = y + height - 2 * i - 1;
            if ((this.linePart & 1) != 0) {
                g.drawLine(startX, startY, endX, startY);
            }
            if ((this.linePart & 4) != 0) {
                g.drawLine(startX, startY, startX, endY);
            }
            if ((this.linePart & 2) != 0) {
                g.drawLine(startX, endY, endX, endY);
            }
            if ((this.linePart & 8) == 0) continue;
            g.drawLine(endX, startY, endX, endY);
        }
        g.setColor(oldColor);
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(this.inset + ((this.linePart & 1) == 0 ? 0 : this.lineThickness), this.inset + ((this.linePart & 4) == 0 ? 0 : this.lineThickness), this.inset + ((this.linePart & 2) == 0 ? 0 : this.lineThickness), this.inset + ((this.linePart & 8) == 0 ? 0 : this.lineThickness));
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = this.inset + ((this.linePart & 1) == 0 ? 0 : this.lineThickness);
        insets.left = this.inset + ((this.linePart & 4) == 0 ? 0 : this.lineThickness);
        insets.bottom = this.inset + ((this.linePart & 2) == 0 ? 0 : this.lineThickness);
        insets.right = this.inset + ((this.linePart & 8) == 0 ? 0 : this.lineThickness);
        return insets;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getPaintedPart() {
        return this.linePart;
    }

    public int getThickness() {
        return this.lineThickness;
    }

    public boolean isBorderOpaque() {
        return this.inset == 0;
    }
}

