/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.cmp;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.image.ImageObserver;
import javax.swing.JComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageComponent
extends JComponent
implements ImageObserver {
    private static final Dimension DEFAULT_SIZE = new Dimension(200, 250);
    private static Log log = LogFactory.getLog(ImageComponent.class);
    private Image image;
    private MediaTracker track;
    private int imgWidth;
    private int imgHeight;
    private float scale = 1.0f;
    private ImageFit fit = ImageFit.BOTH;

    public ImageComponent() {
        this(null);
    }

    public ImageComponent(Image im) {
        this.track = new MediaTracker(this);
        if (im != null) {
            this.setImage(im, false);
        }
    }

    public void setImage(Image im) {
        this.setImage(im, true);
    }

    private void setImage(Image im, boolean needPaint) {
        if (this.image != null) {
            this.track.removeImage(this.image);
        }
        this.image = im;
        this.scale = 1.0f;
        this.imgWidth = -1;
        this.imgHeight = -1;
        if (this.image != null) {
            this.track.addImage(this.image, 0);
        }
        if (needPaint) {
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        Insets inset = this.getInsets();
        Dimension size = this.getSize();
        int cmpWidth = size.width - (inset.left + inset.right);
        int cmpHeight = size.height - (inset.top + inset.bottom);
        if (this.image != null) {
            this.waitForBits();
            if (this.track.statusID(0, true) != 4) {
                int visualImgHeight;
                int visualImgWidth;
                this.imgWidth = this.image.getWidth(null);
                this.imgHeight = this.image.getHeight(null);
                if (this.imgWidth <= 0 || this.imgHeight <= 0) {
                    log.warn((Object)("Bad image size in paint : " + this.imgWidth + " x " + this.imgHeight));
                }
                if (this.fit == ImageFit.NONE) {
                    visualImgWidth = Math.round((float)this.imgWidth * this.scale);
                    visualImgHeight = Math.round((float)this.imgHeight * this.scale);
                } else {
                    float ratio = (float)this.imgWidth / (float)this.imgHeight;
                    if (this.imgWidth < cmpWidth) {
                        if (this.imgHeight < cmpHeight) {
                            visualImgWidth = this.imgWidth;
                            visualImgHeight = this.imgHeight;
                        } else {
                            visualImgWidth = (int)((float)cmpHeight * ratio);
                            visualImgHeight = cmpHeight;
                        }
                    } else if (this.imgHeight <= cmpHeight) {
                        visualImgWidth = cmpWidth;
                        visualImgHeight = (int)((float)cmpWidth / ratio);
                    } else {
                        int ssX = (int)((float)cmpHeight * ratio);
                        int ssY = (int)((float)cmpWidth / ratio);
                        if (ssY <= cmpHeight) {
                            visualImgWidth = cmpWidth;
                            visualImgHeight = ssY;
                        } else {
                            visualImgWidth = ssX;
                            visualImgHeight = cmpHeight;
                        }
                    }
                }
                int posX = (cmpWidth - visualImgWidth) / 2;
                int posY = (cmpHeight - visualImgHeight) / 2;
                g.drawImage(this.image, posX + inset.left, posY + inset.top, visualImgWidth, visualImgHeight, this.getBackground(), this);
                this.scale = (float)visualImgHeight / (float)this.imgHeight;
            } else {
                log.error((Object)"Image not properly loaded in tracker", (Throwable)new Exception("Stack dump"));
                g.setColor(this.getBackground());
                g.fillRect(inset.left, inset.top, cmpWidth, cmpHeight);
                this.scale = 1.0f;
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.image == null || this.imgWidth < 0 || this.imgHeight < 0) {
            return DEFAULT_SIZE;
        }
        if (this.fit != ImageFit.NONE) {
            return DEFAULT_SIZE;
        }
        return new Dimension(Math.round((float)this.imgWidth * this.scale), Math.round((float)this.imgHeight * this.scale));
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float newScale) {
        this.scale = newScale;
    }

    public ImageFit getFit() {
        return this.fit;
    }

    public void setFit(ImageFit newFit) {
        this.fit = newFit;
    }

    public int getImageWidth() {
        if (this.image == null) {
            return 0;
        }
        if (this.imgWidth <= 0) {
            this.waitForBits();
            this.imgWidth = this.image.getWidth(null);
        }
        return this.imgWidth;
    }

    public int getImageHeight() {
        if (this.image == null) {
            return 0;
        }
        if (this.imgHeight <= 0) {
            this.waitForBits();
            this.imgHeight = this.image.getHeight(null);
        }
        return this.imgHeight;
    }

    public Dimension getImageSize() {
        Dimension result = null;
        if (this.image != null) {
            this.waitForBits();
            int imX = this.image.getWidth(null);
            int imY = this.image.getHeight(null);
            if (imX <= 0 || imY <= 0) {
                log.warn((Object)("Bad image size : " + imX + "," + imY));
            }
            result = new Dimension(imX, imY);
        }
        return result;
    }

    private void waitForBits() {
        try {
            if (this.image != null && this.track.statusID(0, true) == 1) {
                this.track.waitForID(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("Exception while loading image: " + this.image), (Throwable)e);
        }
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if (this.isShowing() && this.isComponentImage(img)) {
            return super.imageUpdate(img, infoflags, x, y, width, height);
        }
        return false;
    }

    public boolean isComponentImage(Image img) {
        return img == this.image;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageFit {
        NONE,
        VERTICAL,
        HORIZONTAL,
        BOTH;

    }
}

