/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.cmp;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class DateTimeChooser
extends JDialog {
    private static final Color DEFAULT_FOREGROUND = Color.gray;
    private static final Color DEFAULT_BACKGROUND = Color.white;
    private static final Color WEEK_END_BACKGROUND = new Color(240, 240, 250);
    private static final Color SELECTED_FOREGROUND = Color.white;
    private static final Color SELECTED_BACKGROUND = Color.orange;
    private Calendar cal;
    private Date selectedDate;
    private JComboBox monthCombo;
    private JLabel[] dayLabels;
    private JPanel daysPanel;
    private JTextField yearTextField;
    private JScrollBar yearUpDn;
    private JTextField hourTextField;
    private JScrollBar hourUpDn;
    private JTextField minuteTextField;
    private JScrollBar minuteUpDn;
    private JTextField secondTextField;
    private JScrollBar secondUpDn;
    private JLabel selectedLabel;
    private Color selectedLabelBackround;

    public DateTimeChooser(Frame parent, String title, boolean showTime) {
        super(parent, title, true);
        this.init(showTime);
    }

    public DateTimeChooser(Dialog parent, String title, boolean showTime) {
        super(parent, title, true);
        this.init(showTime);
    }

    public Date editDate(Date initialDate) {
        if (initialDate == null) {
            initialDate = new Date();
        }
        this.setDate(initialDate);
        this.setVisible(true);
        Date resultDate = this.getSelectedDate();
        return resultDate == null ? initialDate : resultDate;
    }

    public Date getSelectedDate() {
        return this.selectedDate;
    }

    public void setDate(Date newDate) {
        this.cal.setTime(newDate);
        this.updateView();
    }

    private void init(boolean showTime) {
        this.cal = Calendar.getInstance();
        this.createUI(showTime);
        this.setSize(new Dimension(296, showTime ? 320 : 280));
        this.setResizable(false);
    }

    private void createUI(boolean showTime) {
        JPanel bottomPanel;
        DateFormatSymbols dfs = new DateFormatSymbols();
        JPanel topPanel = this.createTopPanel(dfs);
        this.daysPanel = this.createDaysPanel(dfs);
        if (showTime) {
            JPanel hourPanel = this.createHourPanel();
            JPanel buttonsPanel = this.createButtonsPanel();
            bottomPanel = new JPanel(new GridLayout(2, 1));
            bottomPanel.add(hourPanel);
            bottomPanel.add(buttonsPanel);
        } else {
            bottomPanel = this.createButtonsPanel();
        }
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)topPanel, "North");
        contentPane.add((Component)this.daysPanel, "Center");
        contentPane.add((Component)bottomPanel, "South");
        this.setContentPane(contentPane);
    }

    private JPanel createTopPanel(DateFormatSymbols dfs) {
        JPanel topPanel = new JPanel(new GridBagLayout());
        String[] monthNames = dfs.getMonths();
        this.monthCombo = new JComboBox();
        int maxMonth = this.cal.getMaximum(2);
        for (int i = 0; i <= maxMonth; ++i) {
            this.monthCombo.addItem(monthNames[i]);
        }
        this.monthCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DateTimeChooser.this.monthChanged();
                }
            }
        });
        this.yearTextField = new JTextField(5);
        this.yearUpDn = new JScrollBar();
        this.addSelector(topPanel, this.yearTextField, this.yearUpDn, 0, null, 1, 'Y', 5000);
        topPanel.add((Component)this.monthCombo, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 5, 5), 0, 0));
        topPanel.add((Component)this.yearTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 5, 0), 0, 0));
        topPanel.add((Component)this.yearUpDn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 5, 5), 0, 0));
        return topPanel;
    }

    private JPanel createHourPanel() {
        JPanel hourPanel = new JPanel(new GridBagLayout());
        this.hourTextField = new JTextField(3);
        this.hourUpDn = new JScrollBar();
        this.addSelector(hourPanel, this.hourTextField, this.hourUpDn, 0, "Hour:", 11, 'H', 23);
        this.minuteTextField = new JTextField(3);
        this.minuteUpDn = new JScrollBar();
        this.addSelector(hourPanel, this.minuteTextField, this.minuteUpDn, 3, "Min.:", 12, 'M', 59);
        this.secondTextField = new JTextField(3);
        this.secondUpDn = new JScrollBar();
        this.addSelector(hourPanel, this.secondTextField, this.secondUpDn, 6, "Sec.:", 13, 'S', 59);
        return hourPanel;
    }

    private void addSelector(JPanel panel, final JTextField textField, final JScrollBar spin, int index, String label, final int fieldId, char mnemonic, int maxValue) {
        JLabel fieldLabel;
        textField.setHorizontalAlignment(4);
        textField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                DateTimeChooser.this.fieldChanged(fieldId, textField, spin);
            }
        });
        textField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DateTimeChooser.this.fieldChanged(fieldId, textField, spin);
                }
            }
        });
        if (label != null) {
            fieldLabel = new JLabel(label);
            fieldLabel.setDisplayedMnemonic(mnemonic);
            fieldLabel.setLabelFor(textField);
        } else {
            fieldLabel = null;
        }
        int textFieldHeight = textField.getPreferredSize().height;
        spin.setMinimum(0);
        spin.setMaximum(maxValue + 10);
        spin.setUnitIncrement(-1);
        spin.setBlockIncrement(1);
        spin.setPreferredSize(new Dimension(20, textFieldHeight));
        spin.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                DateTimeChooser.this.fieldSpinClicked(fieldId, textField, spin);
            }
        });
        if (fieldLabel != null) {
            panel.add((Component)fieldLabel, new GridBagConstraints(index, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(8, 5, 0, 5), 0, 0));
        }
        panel.add((Component)textField, new GridBagConstraints(index + 1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)spin, new GridBagConstraints(index + 2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    private JPanel createDaysPanel(DateFormatSymbols dfs) {
        JPanel daysSelectionPanel = new JPanel(new GridLayout(7, 7, 1, 1));
        Border outBorder = BorderFactory.createEmptyBorder(5, 10, 5, 10);
        Border inBorder = BorderFactory.createLoweredBevelBorder();
        daysSelectionPanel.setBorder(BorderFactory.createCompoundBorder(outBorder, inBorder));
        String[] dayNames = dfs.getShortWeekdays();
        int firstDayOfWeek = this.cal.getFirstDayOfWeek();
        int sundayColumn = -1;
        int saturdayColumn = -1;
        for (int i = firstDayOfWeek; i < firstDayOfWeek + 7; ++i) {
            int nameIndex;
            int n = nameIndex = i > 7 ? i - 7 : i;
            if (nameIndex == 1) {
                sundayColumn = i - firstDayOfWeek;
            }
            if (nameIndex == 7) {
                saturdayColumn = i - firstDayOfWeek;
            }
            daysSelectionPanel.add(new JLabel(dayNames[nameIndex], 0));
        }
        this.dayLabels = new JLabel[42];
        MouseAdapter lis = new MouseAdapter(){

            public void mousePressed(MouseEvent me) {
                DateTimeChooser.this.dayChanged((JLabel)me.getSource());
            }
        };
        for (int i = 0; i < 42; ++i) {
            this.dayLabels[i] = new JLabel(String.valueOf(i), 0);
            this.dayLabels[i].setForeground(DEFAULT_FOREGROUND);
            this.dayLabels[i].addMouseListener(lis);
            int column = i % 7;
            boolean weekEnd = column == saturdayColumn || column == sundayColumn;
            this.dayLabels[i].setBackground(weekEnd ? WEEK_END_BACKGROUND : DEFAULT_BACKGROUND);
            daysSelectionPanel.add(this.dayLabels[i]);
        }
        return daysSelectionPanel;
    }

    private JPanel createButtonsPanel() {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        JButton okButton = new JButton("Ok");
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DateTimeChooser.this.closeWithOk();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DateTimeChooser.this.setVisible(false);
            }
        });
        buttonsPanel.add(okButton);
        buttonsPanel.add(cancelButton);
        return buttonsPanel;
    }

    void fieldChanged(int fieldId, JTextField textField, JScrollBar spinButtons) {
        String txtValue = textField.getText();
        try {
            int value = Integer.parseInt(txtValue);
            this.cal.set(fieldId, value);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.updateViewForFieldChange(fieldId, textField, spinButtons);
    }

    void fieldSpinClicked(int fieldId, JTextField textField, JScrollBar spinButtons) {
        this.cal.set(fieldId, spinButtons.getValue());
        this.updateViewForFieldChange(fieldId, textField, spinButtons);
    }

    private void updateViewForFieldChange(int fieldId, JTextField textField, JScrollBar spinButtons) {
        if (textField != null) {
            int value = this.cal.get(fieldId);
            textField.setText(String.valueOf(value));
            spinButtons.setValue(value);
            if (fieldId == 1) {
                this.monthChanged();
            }
        }
    }

    void monthChanged() {
        int currentDay = this.cal.get(5);
        int month = this.monthCombo.getSelectedIndex();
        this.cal.set(5, 1);
        this.cal.set(2, month);
        int firstDayOfWeek = this.cal.getFirstDayOfWeek();
        int dayOfWeekOfFirstDay = this.cal.get(7);
        int maxDayOfMonth = this.cal.getActualMaximum(5);
        if (currentDay > maxDayOfMonth) {
            currentDay = maxDayOfMonth;
        }
        this.cal.set(5, currentDay);
        int startIndex = dayOfWeekOfFirstDay - firstDayOfWeek;
        if (startIndex < 0) {
            startIndex += 7;
        }
        int endIndex = startIndex + maxDayOfMonth - 1;
        for (int i = 0; i < 42; ++i) {
            if (i < startIndex || i > endIndex) {
                this.dayLabels[i].setText("");
                this.dayLabels[i].setOpaque(false);
                continue;
            }
            int day = i - startIndex + 1;
            this.dayLabels[i].setText(String.valueOf(day));
            this.dayLabels[i].setOpaque(true);
            if (day != currentDay) continue;
            this.highlightLabel(this.dayLabels[i]);
        }
        this.daysPanel.repaint();
    }

    void closeWithOk() {
        this.selectedDate = this.cal.getTime();
        this.setVisible(false);
    }

    void dayChanged(JLabel lbl) {
        String labelText = lbl.getText();
        if (labelText != null && !labelText.equals("")) {
            int day = Integer.parseInt(labelText);
            this.cal.set(5, day);
            this.highlightLabel(lbl);
        }
    }

    private void updateView() {
        this.monthCombo.setSelectedIndex(this.cal.get(2));
        this.updateViewForFieldChange(1, this.yearTextField, this.yearUpDn);
        this.updateViewForFieldChange(11, this.hourTextField, this.hourUpDn);
        this.updateViewForFieldChange(12, this.minuteTextField, this.minuteUpDn);
        this.updateViewForFieldChange(13, this.secondTextField, this.secondUpDn);
    }

    private void highlightLabel(JLabel label) {
        if (this.selectedLabel != null) {
            this.selectedLabel.setForeground(DEFAULT_FOREGROUND);
            this.selectedLabel.setBackground(this.selectedLabelBackround);
        }
        if (label != null) {
            this.selectedLabelBackround = label.getBackground();
            label.setForeground(SELECTED_FOREGROUND);
            label.setBackground(SELECTED_BACKGROUND);
        }
        this.selectedLabel = label;
    }
}

