/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.cmp;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.sf.sfac.gui.cmp.SizedDialog;
import net.sf.sfac.lang.LanguageSupport;
import net.sf.sfac.setting.Settings;

public class ConsoleDialog
extends SizedDialog {
    private JTextArea textArea;
    private JButton clearButton;
    private JCheckBox scrollLockCB;
    private JScrollPane scrollPane;

    public ConsoleDialog(Frame owner, String title, Settings sett) {
        super((Component)owner, sett, LanguageSupport.getOptionalLocalizedString((String)"CONSOLE", (String)"Console"));
        this.setTitle(title);
        this.buildGui();
    }

    public ConsoleDialog(Dialog owner, String title, Settings sett) {
        super(owner, sett, LanguageSupport.getOptionalLocalizedString((String)"CONSOLE", (String)"Console"));
        this.setTitle(title);
        this.buildGui();
    }

    private void buildGui() {
        this.textArea = new JTextArea();
        this.scrollPane = new JScrollPane(this.textArea);
        JPanel bottomPane = new JPanel();
        bottomPane.setLayout(new BoxLayout(bottomPane, 0));
        this.scrollLockCB = new JCheckBox(LanguageSupport.getOptionalLocalizedString((String)"SCROLL_LOCK", (String)"Scroll Lock"));
        this.clearButton = new JButton(LanguageSupport.getOptionalLocalizedString((String)"CLEAR", (String)"Clear"));
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent newE) {
                ConsoleDialog.this.clear();
            }
        });
        bottomPane.add(this.scrollLockCB);
        bottomPane.add(this.clearButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add((Component)this.scrollPane, "Center");
        contentPane.add((Component)bottomPane, "South");
    }

    public boolean isScrollLock() {
        return this.scrollLockCB.isSelected();
    }

    public void setScrollLock(boolean scrollLock) {
        this.scrollLockCB.setSelected(scrollLock);
    }

    public void clear() {
        this.textArea.setText("");
    }

    public void write(String txt) {
        this.append(txt);
    }

    public void writeln(String txt) {
        this.append(txt);
        this.append("\n");
    }

    public void append(final String txt) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.textArea.append(txt);
            if (!this.isScrollLock()) {
                Dimension textAreaSize = this.textArea.getSize();
                int textAreaHeight = textAreaSize.height;
                if (textAreaHeight > 16) {
                    Rectangle bottomRect = new Rectangle(0, textAreaHeight - 16, 16, 16);
                    this.textArea.scrollRectToVisible(bottomRect);
                }
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ConsoleDialog.this.append(txt);
                }
            });
        }
    }

    public void append(int i) {
        this.append(String.valueOf(i));
    }

    public void append(char ch) {
        this.append(String.valueOf(ch));
    }

    public void append(byte[] b) {
        this.append(new String(b));
    }

    public void append(byte[] b, int start, int len) {
        this.append(new String(b, start, len));
    }

    public OutputStream getConsoleStream() {
        return new ConsoleStream();
    }

    class ConsoleStream
    extends OutputStream {
        ConsoleStream() {
        }

        public void write(int b) throws IOException {
            ConsoleDialog.this.append((char)b);
        }

        public void write(byte[] b) throws IOException {
            ConsoleDialog.this.append(b);
        }

        public void write(byte[] b, int start, int len) throws IOException {
            ConsoleDialog.this.append(b, start, len);
        }
    }
}

