/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.asynch;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import javax.swing.Timer;

public class WaitManager {
    private static final Cursor DEFAULT_CURSOR = Cursor.getDefaultCursor();
    private static final Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    private Component controlledComp;
    private int busyCount;
    private Timer tim;
    private int nbrTick;
    private BlockinEventQueue blocker;
    private Cursor currentCursor;

    public WaitManager(Component controlledCmp) {
        this.controlledComp = controlledCmp;
        this.tim = new Timer(200, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WaitManager.this.timerTick();
            }
        });
    }

    public void setBusy(boolean busy) {
        if (busy) {
            if (this.busyCount == 0) {
                this.nbrTick = 0;
                this.blocker = new BlockinEventQueue();
                this.blocker.start();
                this.tim.start();
            }
            ++this.busyCount;
        } else {
            if (this.busyCount <= 0) {
                throw new IllegalStateException("Cannot set busy false when not busy");
            }
            --this.busyCount;
            if (this.busyCount == 0) {
                this.nbrTick = 0;
                this.blocker.stop();
                this.tim.stop();
                if (this.currentCursor != DEFAULT_CURSOR) {
                    this.controlledComp.setCursor(DEFAULT_CURSOR);
                    this.currentCursor = DEFAULT_CURSOR;
                }
            }
        }
    }

    public boolean isBusy() {
        return this.busyCount > 0;
    }

    void timerTick() {
        ++this.nbrTick;
        if (this.nbrTick >= 2 && this.currentCursor != WAIT_CURSOR) {
            this.controlledComp.setCursor(WAIT_CURSOR);
            this.currentCursor = WAIT_CURSOR;
        }
        if (this.nbrTick > 1000) {
            System.out.println("TIME OUT for hourglass");
            while (this.isBusy()) {
                this.setBusy(false);
            }
        }
    }

    static class BlockinEventQueue
    extends EventQueue {
        BlockinEventQueue() {
        }

        void start() {
            Toolkit.getDefaultToolkit().getSystemEventQueue().push(this);
        }

        void stop() {
            this.pop();
        }

        protected void dispatchEvent(AWTEvent event) {
            if (event instanceof InputEvent) {
                ((InputEvent)event).consume();
            } else if (!event.getClass().getName().endsWith("ComponentWorkRequest")) {
                super.dispatchEvent(event);
            }
        }
    }
}

