/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.asynch;

import java.awt.Component;
import net.sf.sfac.gui.asynch.AsynchStatusDialog;
import net.sf.sfac.gui.asynch.AsynchStatusProvider;
import net.sf.sfac.gui.asynch.UserAbortException;
import net.sf.sfac.lang.LanguageSupport;
import net.sf.sfac.setting.Settings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AsynchStatusProviderImpl
implements AsynchStatusProvider {
    private static Log log = LogFactory.getLog(AsynchStatusProviderImpl.class);
    private Settings setts;
    private AsynchStatusProvider.ActionStatus actionStatus;
    private String actionMessage;
    private AsynchStatusDialog statusDialog;

    public AsynchStatusProviderImpl(Settings settngs) {
        this.setts = settngs;
    }

    public void setStatus(AsynchStatusProvider.ActionStatus newStatus) {
        this.actionStatus = newStatus;
    }

    public String getActionMessage() {
        return this.actionMessage;
    }

    public void setActionMessage(String newActionMessage) {
        this.actionMessage = newActionMessage;
    }

    public Settings getSettings() {
        return this.setts;
    }

    protected void berforeAction(Component parent) {
    }

    protected void afterAction(Component parent) {
    }

    protected abstract void doExecute(Component var1, Object var2) throws Exception;

    public void execute(final Component parent, final Object parameters) throws Exception {
        this.actionStatus = AsynchStatusProvider.ActionStatus.RUNNING;
        this.actionMessage = LanguageSupport.getOptionalLocalizedString((String)"starting_action", (String)"Starting ...");
        this.berforeAction(parent);
        if (this.actionStatus == AsynchStatusProvider.ActionStatus.RUNNING) {
            new Thread("AsynchroneAction"){

                public void run() {
                    AsynchStatusProviderImpl.this.doExecuteProtected(parent, parameters);
                }
            }.start();
            this.showStatusDialog(parent);
            this.afterAction(parent);
        }
    }

    protected void doExecuteProtected(Component parent, Object parameters) {
        try {
            while (this.statusDialog == null || !this.statusDialog.isVisible()) {
                Thread.sleep(50L);
            }
            this.doExecute(parent, parameters);
            if (this.getStatus() == AsynchStatusProvider.ActionStatus.RUNNING) {
                this.setStatus(AsynchStatusProvider.ActionStatus.DONE);
            }
        }
        catch (UserAbortException uae) {
            log.warn((Object)(this.getClass().getSimpleName() + " action aborted by user"));
            this.actionMessage = "Aborted";
            this.actionStatus = AsynchStatusProvider.ActionStatus.ABORTED;
        }
        catch (Exception e) {
            log.error((Object)(this.getClass().getSimpleName() + " action failure"), (Throwable)e);
            this.actionMessage = e.getClass().getSimpleName() + ": " + e.getMessage();
            this.actionStatus = AsynchStatusProvider.ActionStatus.FAILED;
        }
    }

    protected void showStatusDialog(Component parent) {
        this.statusDialog = new AsynchStatusDialog(parent, this, this.setts);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Create status dialog: " + this.statusDialog));
        }
        this.statusDialog.startUpdates();
        this.statusDialog.setVisible(true);
    }

    protected void disposeStatusDialog() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dispose status dialog: " + this.statusDialog));
        }
        if (this.statusDialog != null) {
            this.statusDialog.dispose();
            this.statusDialog = null;
        }
    }

    public void cancelAction() {
        this.actionStatus = this.actionStatus == AsynchStatusProvider.ActionStatus.RUNNING ? AsynchStatusProvider.ActionStatus.ABORTED : AsynchStatusProvider.ActionStatus.TO_DISPOSE;
    }

    public void okAction() {
        this.actionStatus = AsynchStatusProvider.ActionStatus.TO_DISPOSE;
    }

    public boolean displayOkButton() {
        return true;
    }

    public boolean displayCancelButton() {
        return true;
    }

    public boolean isCancelAllowed() {
        return this.actionStatus == AsynchStatusProvider.ActionStatus.RUNNING;
    }

    public String getProviderId() {
        return this.getClass().getSimpleName();
    }

    public AsynchStatusProvider.ActionStatus getStatus() {
        return this.actionStatus;
    }

    public boolean hasStatusLineChanged(int newIndex) {
        return true;
    }

    public boolean displayProgressBar() {
        return false;
    }

    public int getPercentComplete() {
        return 0;
    }
}

