/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui.asynch;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import net.sf.sfac.gui.asynch.AsynchStatusProvider;
import net.sf.sfac.gui.cmp.SizedDialog;
import net.sf.sfac.lang.LanguageSupport;
import net.sf.sfac.setting.Settings;

public class AsynchStatusDialog
extends SizedDialog {
    private AsynchStatusProvider provider;
    private JLabel[] labels;
    private AsynchStatusProvider.ActionStatus currentStatus;
    private JProgressBar progressBar;
    private JButton okButton;
    private JButton cancelButton;
    private Timer updateTimer;

    public AsynchStatusDialog(Component owner, AsynchStatusProvider prov, Settings sett) {
        super(owner, sett, prov.getProviderId() + ".dial");
        this.setModal(true);
        if (!prov.displayCancelButton()) {
            this.setDefaultCloseOperation(0);
        }
        this.provider = prov;
        this.setTitle(LanguageSupport.getOptionalLocalizedString((String)(prov.getProviderId() + "_title"), (String)prov.getProviderId()));
        this.buildGui();
        this.setDefaultLocation(SizedDialog.LocationType.RELATIVE, new Rectangle(20, 50, 450, AsynchStatusDialog.getPreferredHeight(this.provider)));
    }

    private static int getPreferredHeight(AsynchStatusProvider prov) {
        int height = 50;
        if (prov.displayCancelButton() || prov.displayOkButton()) {
            height += 50;
        }
        if (prov.displayProgressBar()) {
            height += 30;
        }
        return height += 24 * prov.getStatusLineCount();
    }

    public void startUpdates() {
        this.updateTimer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent newE) {
                AsynchStatusDialog.this.updateView();
            }
        });
        this.updateTimer.start();
    }

    private void buildGui() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        int len = this.provider.getStatusLineCount();
        this.labels = new JLabel[len];
        int row = 0;
        for (int i = 0; i < len; ++i) {
            this.labels[i] = new JLabel();
            contentPane.add((Component)this.labels[i], new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 2, 0), 0, 0));
            ++row;
        }
        if (this.provider.displayProgressBar()) {
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setStringPainted(true);
            contentPane.add((Component)this.progressBar, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 0, 2, 0), 0, 0));
            ++row;
        }
        if (this.provider.displayOkButton() || this.provider.displayCancelButton()) {
            JPanel buttonPane = new JPanel();
            if (this.provider.displayOkButton()) {
                String okLabel = LanguageSupport.getOptionalLocalizedString((String)"OK", (String)"Ok");
                this.okButton = new JButton(okLabel);
                this.okButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent newE) {
                        AsynchStatusDialog.this.done();
                    }
                });
                buttonPane.add(this.okButton);
            }
            if (this.provider.displayCancelButton()) {
                String cancelLabel = LanguageSupport.getOptionalLocalizedString((String)"CANCEL", (String)"Cancel");
                this.cancelButton = new JButton(cancelLabel);
                this.cancelButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent newE) {
                        AsynchStatusDialog.this.cancel();
                    }
                });
                buttonPane.add(this.cancelButton);
            }
            contentPane.add((Component)buttonPane, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 10, 0, new Insets(6, 0, 0, 2), 0, 0));
            ++row;
        }
        this.setContentPane(contentPane);
        this.updateView();
    }

    public boolean isCancelAllowed() {
        return this.currentStatus == AsynchStatusProvider.ActionStatus.RUNNING;
    }

    void done() {
        this.provider.okAction();
        this.updateView();
    }

    public void dispose() {
        if (this.updateTimer != null) {
            this.updateTimer.stop();
        }
        super.dispose();
    }

    void cancel() {
        this.provider.cancelAction();
        this.updateView();
    }

    void updateView() {
        int len = this.provider.getStatusLineCount();
        for (int i = 0; i < len; ++i) {
            if (!this.provider.hasStatusLineChanged(i)) continue;
            this.labels[i].setText(this.provider.getStatusLine(i));
            this.labels[i].setMinimumSize(this.labels[i].getPreferredSize());
        }
        if (this.currentStatus != this.provider.getStatus()) {
            this.currentStatus = this.provider.getStatus();
            if (this.currentStatus == AsynchStatusProvider.ActionStatus.TO_DISPOSE) {
                this.dispose();
            } else {
                boolean running;
                boolean bl = running = this.currentStatus == AsynchStatusProvider.ActionStatus.RUNNING;
                if (this.okButton != null) {
                    this.okButton.setEnabled(!running);
                }
                if (this.cancelButton != null) {
                    this.cancelButton.setEnabled(this.provider.isCancelAllowed());
                }
            }
        }
        if (this.progressBar != null) {
            int percent = 100;
            if (this.currentStatus != AsynchStatusProvider.ActionStatus.DONE) {
                percent = this.provider.getPercentComplete();
            }
            this.progressBar.setValue(percent);
        }
    }
}

