/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class UiUtils {
    public static JComponent getMultiLineComponent(String text, int nbrMax) {
        StringTokenizer st = new StringTokenizer(text, "\n");
        int len = st.countTokens();
        JPanel linesPanel = new JPanel(new GridLayout(len, 1));
        for (int i = 0; i < len; ++i) {
            String line = st.nextToken();
            linesPanel.add(new JLabel(line));
        }
        if (len <= nbrMax) {
            return linesPanel;
        }
        Dimension dim = linesPanel.getPreferredSize();
        JScrollPane scroll = new JScrollPane(linesPanel, 20, 31);
        scroll.setPreferredSize(new Dimension(dim.width + 20, dim.height * nbrMax / len));
        return scroll;
    }

    public static boolean paintImage(Graphics g, Image image, int x, int y, int width, int height, Color bg, ImageObserver obs) {
        boolean succeed = false;
        int imWidth = image.getWidth(obs);
        int imHeight = image.getHeight(obs);
        if (imWidth > 0 && imHeight > 0) {
            int posY;
            int posX;
            int paintedHeight;
            int paintedWidth;
            float ratio = (float)imWidth / (float)imHeight;
            if (imWidth < width) {
                if (imHeight < height) {
                    paintedWidth = imWidth;
                    paintedHeight = imHeight;
                    posX = (width - paintedWidth) / 2;
                    posY = (height - paintedHeight) / 2;
                } else {
                    paintedWidth = (int)((float)height * ratio);
                    paintedHeight = height;
                    posX = (width - paintedWidth) / 2;
                    posY = 0;
                }
            } else if (imHeight <= height) {
                paintedWidth = width;
                paintedHeight = (int)((float)width / ratio);
                posX = 0;
                posY = (height - paintedHeight) / 2;
            } else {
                int tempWidth = (int)((float)height * ratio);
                int tempHeight = (int)((float)width / ratio);
                if (tempHeight <= height) {
                    paintedWidth = width;
                    paintedHeight = tempHeight;
                    posX = 0;
                    posY = (height - paintedHeight) / 2;
                } else {
                    paintedWidth = tempWidth;
                    paintedHeight = height;
                    posX = (width - paintedWidth) / 2;
                    posY = 0;
                }
            }
            succeed = bg == null ? g.drawImage(image, x + posX, y + posY, paintedWidth, paintedHeight, obs) : g.drawImage(image, x + posX, y + posY, paintedWidth, paintedHeight, bg, obs);
        }
        return succeed;
    }

    public static void resizeLabelFont(JComponent lbl, float factor, boolean centerText) {
        Font labelFont = lbl.getFont();
        lbl.setFont(labelFont.deriveFont(factor * labelFont.getSize2D()));
        if (centerText && lbl instanceof JLabel) {
            ((JLabel)lbl).setHorizontalAlignment(0);
        }
    }

    public static void setBackground(Component cmp, Color col) {
        Container cont;
        Component[] subCmp;
        cmp.setBackground(col);
        if (cmp instanceof Container && (subCmp = (cont = (Container)cmp).getComponents()) != null) {
            for (Component sub : subCmp) {
                UiUtils.setBackground(sub, col);
            }
        }
    }
}

