/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui;

import java.awt.Component;
import javax.swing.JOptionPane;
import net.sf.sfac.lang.LanguageSupport;

public class SystemDialog {
    public static final String[] OPTIONS_OK = new String[]{"OK"};
    public static final String[] OPTIONS_YES_NO = new String[]{"YES", "NO"};
    public static final String[] OPTIONS_YES_NO_CANCEL = new String[]{"YES", "NO", "CANCEL"};
    public static final String[] OPTIONS_OK_CANCEL = new String[]{"OK", "CANCEL"};

    public static final int showDialog(Component parent, String titleTag, String messageTag, Object[] messageParam, int optionsType, int dialogType) {
        String[] optionsTags;
        switch (optionsType) {
            case -1: {
                optionsTags = OPTIONS_OK;
                break;
            }
            case 0: {
                optionsTags = OPTIONS_YES_NO;
                break;
            }
            case 1: {
                optionsTags = OPTIONS_YES_NO_CANCEL;
                break;
            }
            case 2: {
                optionsTags = OPTIONS_OK_CANCEL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown options type: " + optionsType);
            }
        }
        return SystemDialog.showDialog(parent, titleTag, messageTag, messageParam, optionsTags, optionsTags[0], dialogType);
    }

    public static final int showDialog(Component parent, String titleTag, String messageTag, Object[] messageParam, String[] optionsTags, String defaultOptionTag, int dialogType) {
        String titre = LanguageSupport.getLocalizedString((String)titleTag);
        String mess = LanguageSupport.getLocalizedString((String)messageTag, (Object[])messageParam);
        int nbrOptions = optionsTags.length;
        Object[] options = new String[nbrOptions];
        for (int i = 0; i < nbrOptions; ++i) {
            options[i] = LanguageSupport.getLocalizedString((String)optionsTags[i]);
        }
        String defaultOption = LanguageSupport.getLocalizedString((String)defaultOptionTag);
        return JOptionPane.showOptionDialog(parent, mess, titre, 0, dialogType, null, options, defaultOption);
    }
}

