/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sfac.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import net.sf.sfac.lang.LanguageSupport;
import net.sf.sfac.lang.MultiLingualText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionDialog
extends JDialog {
    private Throwable underlyingException;
    private JButton detailButton;
    private JPanel contentPane;
    private JComponent detailPane;
    private Frame parentFrame;

    public static void showDefaultDialog(Component cmp, Throwable t) {
        ExceptionDialog.showDefaultDialog(cmp, null, t);
    }

    public static void showDefaultDialog(Component cmp, String executedActionTag, Throwable t) {
        Frame frm = JOptionPane.getFrameForComponent(cmp);
        String messageTag = "INTERNAL_ERROR";
        Object[] params = null;
        if (executedActionTag != null) {
            messageTag = "INTERNAL_ERROR_IN_ACTION";
            String actionText = LanguageSupport.getLocalizedString((String)executedActionTag);
            params = new Object[]{actionText};
        }
        ExceptionDialog exDial = new ExceptionDialog(frm, "ERROR", messageTag, params, false, t);
        exDial.setVisible(true);
    }

    public static void showExceptionDialog(Component cmp, String titleTag, String messageTag, Throwable t) {
        Frame frm = JOptionPane.getFrameForComponent(cmp);
        ExceptionDialog exDial = new ExceptionDialog(frm, titleTag, messageTag, null, true, t);
        exDial.setVisible(true);
    }

    public static void showExceptionDialog(Component cmp, String titleTag, String messageTag, Object[] params, Throwable t) {
        Frame frm = JOptionPane.getFrameForComponent(cmp);
        ExceptionDialog exDial = new ExceptionDialog(frm, titleTag, messageTag, params, true, t);
        exDial.setVisible(true);
    }

    public ExceptionDialog(Frame frm, String titleTag, String messageTag, Object[] params, boolean merge, Throwable t) {
        super(frm, LanguageSupport.getLocalizedString((String)titleTag), true);
        this.parentFrame = frm;
        this.contentPane = new JPanel(new BorderLayout(5, 5));
        this.underlyingException = t;
        JPanel upperPanel = new JPanel(new FlowLayout(1, 10, 0));
        Icon errorIcon = UIManager.getIcon("OptionPane.errorIcon");
        upperPanel.add((Component)new JLabel(errorIcon), "West");
        String text = this.getDisplayText(messageTag, params, merge, t);
        JComponent textPanel = ExceptionDialog.getMultiLineComponent(text, 20);
        upperPanel.add((Component)textPanel, "Center");
        this.contentPane.add((Component)upperPanel, "North");
        JPanel buttonsPanel = new JPanel();
        JButton okButton = new JButton(LanguageSupport.getOptionalLocalizedString((String)"OK", (String)"Ok"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ExceptionDialog.this.dispose();
            }
        });
        buttonsPanel.add(okButton);
        this.detailButton = new JButton(LanguageSupport.getOptionalLocalizedString((String)"DETAILS", (String)"Details"));
        this.detailButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ExceptionDialog.this.showDetails();
            }
        });
        buttonsPanel.add(this.detailButton);
        this.contentPane.add((Component)buttonsPanel, "South");
        this.contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.setContentPane(this.contentPane);
        this.resetBounds();
    }

    private String getDisplayText(String messageTag, Object[] params, boolean merge, Throwable t) {
        int len;
        String baseText = LanguageSupport.getLocalizedString((String)messageTag, (Object[])params);
        List<String> exceptionText = this.getExceptionText(t);
        if (exceptionText == null) {
            return baseText;
        }
        if (merge) {
            exceptionText.add(0, baseText);
        }
        if ((len = exceptionText.size()) == 1) {
            return exceptionText.get(0);
        }
        StringBuffer sb = new StringBuffer();
        for (String text : exceptionText) {
            if (sb.length() > 0) {
                sb.append("\n\n");
            }
            sb.append(text);
        }
        return sb.toString();
    }

    private List<String> getExceptionText(Throwable t) {
        ArrayList<String> texts = null;
        Locale loc = LanguageSupport.getCurrentLocale();
        while (t != null) {
            if (t instanceof MultiLingualText) {
                if (texts == null) {
                    texts = new ArrayList<String>();
                }
                texts.add(((MultiLingualText)t).getText(loc));
            }
            t = t.getCause();
        }
        return texts;
    }

    void showDetails() {
        this.detailButton.setEnabled(false);
        this.detailPane = ExceptionDialog.getMultiLineComponent(this.getStringTrace(), 20);
        this.contentPane.add((Component)this.detailPane, "Center");
        this.contentPane.revalidate();
        this.resetBounds();
    }

    private String getStringTrace() {
        StringWriter stringTrace = new StringWriter();
        this.underlyingException.printStackTrace(new PrintWriter((Writer)stringTrace, true));
        String trace = stringTrace.toString();
        trace = trace.replace('\t', ' ');
        trace = trace.replace('\r', ' ');
        return trace;
    }

    private void resetBounds() {
        this.pack();
        int posX = 20;
        int posY = 20;
        if (this.parentFrame != null) {
            Rectangle rect = this.parentFrame.getBounds();
            Dimension size = this.getSize();
            posX = rect.x + (rect.width - size.width) / 2;
            if (posX < 20) {
                posX = 20;
            }
            if ((posY = rect.y + (rect.height - size.height) / 2) < 20) {
                posY = 20;
            }
        }
        this.setLocation(posX, posY);
    }

    private static JComponent getMultiLineComponent(String text, int nbrMax) {
        StringTokenizer st = new StringTokenizer(text, "\n");
        int len = st.countTokens();
        JPanel linesPanel = new JPanel(new GridLayout(len, 1));
        for (int i = 0; i < len; ++i) {
            String line = st.nextToken();
            linesPanel.add(new JLabel(line));
        }
        if (len <= nbrMax) {
            return linesPanel;
        }
        Dimension dim = linesPanel.getPreferredSize();
        JScrollPane scroll = new JScrollPane(linesPanel, 20, 31);
        scroll.setPreferredSize(new Dimension(dim.width + 16, dim.height * nbrMax / len));
        return scroll;
    }
}

