/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;

public final class SavedNamespaceContext
implements NamespaceResolver {
    private Map<String, String> bindings = new HashMap<String, String>();

    public SavedNamespaceContext(Iterable<NamespaceBinding> nsBindings) {
        this(nsBindings.iterator());
    }

    public SavedNamespaceContext(Iterator<NamespaceBinding> nsBindings) {
        while (nsBindings.hasNext()) {
            NamespaceBinding next = nsBindings.next();
            this.bindings.put(next.getPrefix(), next.getURI());
        }
    }

    public SavedNamespaceContext(Iterator<NamespaceBinding> nsBindings, Predicate<NamespaceBinding> excluded) {
        while (nsBindings.hasNext()) {
            NamespaceBinding next = nsBindings.next();
            if (excluded.test(next)) continue;
            this.bindings.put(next.getPrefix(), next.getURI());
        }
    }

    public SavedNamespaceContext(NamespaceResolver resolver) {
        Iterator<String> iter = resolver.iteratePrefixes();
        while (iter.hasNext()) {
            String prefix = iter.next();
            String uri = resolver.getURIForPrefix(prefix, true);
            this.bindings.put(prefix, uri);
        }
    }

    @Override
    public String getURIForPrefix(String prefix, boolean useDefault) {
        if (prefix.isEmpty() && !useDefault) {
            return "";
        }
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        String uri = this.bindings.get(prefix);
        if (uri == null) {
            return prefix.isEmpty() ? "" : null;
        }
        return uri;
    }

    @Override
    public Iterator<String> iteratePrefixes() {
        ArrayList<String> prefixes = new ArrayList<String>(this.bindings.size() + 1);
        prefixes.addAll(this.bindings.keySet());
        prefixes.add("xml");
        return prefixes.iterator();
    }

    public boolean equals(Object obj) {
        return obj instanceof SavedNamespaceContext && this.bindings.equals(((SavedNamespaceContext)obj).bindings);
    }

    public int hashCode() {
        return this.bindings.hashCode();
    }
}

