/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml.parser;

import com.google.common.base.Function;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.io.graphml.EdgeMetadata;
import edu.uci.ics.jung.io.graphml.GraphMetadata;
import edu.uci.ics.jung.io.graphml.HyperEdgeMetadata;
import edu.uci.ics.jung.io.graphml.KeyMap;
import edu.uci.ics.jung.io.graphml.NodeMetadata;
import edu.uci.ics.jung.io.graphml.parser.ElementParserRegistry;

public class ParserContext<G extends Hypergraph<V, E>, V, E> {
    private final KeyMap keyMap;
    private final ElementParserRegistry<G, V, E> elementParserRegistry;
    private final Function<GraphMetadata, G> graphTransformer;
    private final Function<NodeMetadata, V> vertexTransformer;
    private final Function<EdgeMetadata, E> edgeTransformer;
    private final Function<HyperEdgeMetadata, E> hyperEdgeTransformer;

    public ParserContext(ElementParserRegistry<G, V, E> elementParserRegistry, KeyMap keyMap, Function<GraphMetadata, G> graphTransformer, Function<NodeMetadata, V> vertexTransformer, Function<EdgeMetadata, E> edgeTransformer, Function<HyperEdgeMetadata, E> hyperEdgeTransformer) {
        this.elementParserRegistry = elementParserRegistry;
        this.keyMap = keyMap;
        this.graphTransformer = graphTransformer;
        this.vertexTransformer = vertexTransformer;
        this.edgeTransformer = edgeTransformer;
        this.hyperEdgeTransformer = hyperEdgeTransformer;
    }

    public ElementParserRegistry<G, V, E> getElementParserRegistry() {
        return this.elementParserRegistry;
    }

    public KeyMap getKeyMap() {
        return this.keyMap;
    }

    public G createGraph(GraphMetadata metadata) {
        return (G)((Hypergraph)this.graphTransformer.apply((Object)metadata));
    }

    public V createVertex(NodeMetadata metadata) {
        return (V)this.vertexTransformer.apply((Object)metadata);
    }

    public E createEdge(EdgeMetadata metadata) {
        return (E)this.edgeTransformer.apply((Object)metadata);
    }

    public E createHyperEdge(HyperEdgeMetadata metadata) {
        return (E)this.hyperEdgeTransformer.apply((Object)metadata);
    }
}

