/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.model;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.serenitybdd.reports.model.BackgroundColor;
import net.thucydides.core.model.TestResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\f\u00a8\u0006\u0019"}, d2={"Lnet/serenitybdd/reports/model/CoverageSegment;", "", "percentage", "", "count", "", "result", "Lnet/thucydides/core/model/TestResult;", "(DILnet/thucydides/core/model/TestResult;)V", "color", "", "getColor", "()Ljava/lang/String;", "getCount", "()I", "getPercentage", "()D", "getResult", "()Lnet/thucydides/core/model/TestResult;", "roundedPercentage", "", "getRoundedPercentage", "()J", "title", "getTitle", "serenity-stats"})
public final class CoverageSegment {
    private final double percentage;
    private final int count;
    @NotNull
    private final TestResult result;
    @NotNull
    private final String color;
    private final long roundedPercentage;
    @NotNull
    private final String title;

    public CoverageSegment(double percentage, int count, @NotNull TestResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.percentage = percentage;
        this.count = count;
        this.result = result;
        this.color = new BackgroundColor().inDarkforResult(this.result);
        this.roundedPercentage = Math.round(this.percentage);
        StringBuilder stringBuilder = new StringBuilder().append(this.roundedPercentage).append("% ");
        String string = this.result.toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        this.title = stringBuilder.append(string).toString();
    }

    public final double getPercentage() {
        return this.percentage;
    }

    public final int getCount() {
        return this.count;
    }

    @NotNull
    public final TestResult getResult() {
        return this.result;
    }

    @NotNull
    public final String getColor() {
        return this.color;
    }

    public final long getRoundedPercentage() {
        return this.roundedPercentage;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }
}

