/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.TestSourcesModel;
import io.cucumber.messages.Messages;
import io.cucumber.plugin.event.TestSourceRead;
import java.io.File;
import java.net.URI;
import java.util.Optional;
import net.thucydides.core.util.Inflector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureFileLoader {
    private final TestSourcesModel testSources = new TestSourcesModel();
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureFileLoader.class);

    private Optional<Messages.GherkinDocument.Feature> featureFrom(URI featureFileUri) {
        String defaultFeatureId = new File(featureFileUri).getName().replace(".feature", "");
        String defaultFeatureName = Inflector.getInstance().humanize(defaultFeatureId, new String[0]);
        this.parseGherkinIn(featureFileUri);
        if (StringUtils.isEmpty((CharSequence)this.testSources.getFeature(featureFileUri).getName())) {
            return Optional.empty();
        }
        Messages.GherkinDocument.Feature feature = this.testSources.getFeature(featureFileUri);
        if (feature.getName().isEmpty()) {
            feature = this.featureWithDefaultName(feature, defaultFeatureName);
        }
        return Optional.of(feature);
    }

    private void parseGherkinIn(URI featureFileUri) {
        try {
            this.testSources.getFeature(featureFileUri);
        }
        catch (Throwable ignoreParsingErrors) {
            LOGGER.warn("Could not parse the Gherkin in feature file " + featureFileUri + ": file ignored");
        }
    }

    public Messages.GherkinDocument.Feature featureWithDefaultName(Messages.GherkinDocument.Feature feature, String defaultName) {
        Messages.GherkinDocument.Feature.Builder featureBuilder = feature.newBuilderForType();
        return featureBuilder.setName(defaultName).addAllTags((Iterable)feature.getTagsList()).setLocation(feature.getLocation()).setLanguage(feature.getLanguage()).setKeyword(feature.getKeyword()).setDescription(feature.getDescription()).addAllChildren((Iterable)feature.getChildrenList()).build();
    }

    public void addTestSourceReadEvent(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.getUri(), event);
    }

    public String getFeatureName(URI featureFileUri) {
        return this.testSources.getFeature(featureFileUri).getName();
    }

    public Messages.GherkinDocument.Feature getFeature(URI featureFileUri) {
        return this.testSources.getFeature(featureFileUri);
    }

    TestSourcesModel.AstNode getAstNode(URI path, int line) {
        return this.testSources.getAstNode(path, line);
    }
}

