/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.serenitybdd.core.environment.WebDriverConfiguredEnvironment;
import net.serenitybdd.model.collect.NewList;
import net.serenitybdd.model.environment.ConfiguredEnvironment;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.webdriver.DevToolsWebDriverFacade;
import net.thucydides.core.webdriver.DriverConfiguration;
import net.thucydides.core.webdriver.ThucydidesWebDriverEventListener;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.model.webdriver.Configuration;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.devtools.HasDevTools;

public class WebdriverProxyFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ThreadLocal<WebdriverProxyFactory> factory = new ThreadLocal();
    private static final List<ThucydidesWebDriverEventListener> eventListeners = Collections.synchronizedList(new ArrayList());
    private final WebDriverFactory webDriverFactory = new WebDriverFactory();
    private WebDriverFacade mockDriver;
    private final DriverConfiguration configuration = WebDriverConfiguredEnvironment.getDriverConfiguration();

    private WebdriverProxyFactory() {
    }

    public static WebdriverProxyFactory getFactory() {
        if (factory.get() == null) {
            factory.set(new WebdriverProxyFactory());
        }
        return factory.get();
    }

    public static List<ThucydidesWebDriverEventListener> getEventListeners() {
        return NewList.copyOf(eventListeners);
    }

    public WebDriverFacade proxyFor(Class<? extends WebDriver> driverClass) {
        return this.proxyFor(driverClass, new WebDriverFactory(), ConfiguredEnvironment.getConfiguration());
    }

    public WebDriverFacade proxyFor(Class<? extends WebDriver> driverClass, WebDriverFactory webDriverFactory, Configuration configuration) {
        return this.proxyFor(driverClass, webDriverFactory, configuration, "");
    }

    public WebDriverFacade proxyFor(Class<? extends WebDriver> driverClass, WebDriverFactory webDriverFactory, Configuration configuration, String options) {
        if (this.mockDriver != null) {
            return this.mockDriver;
        }
        if (driverClass != null && HasDevTools.class.isAssignableFrom(driverClass)) {
            return new DevToolsWebDriverFacade(driverClass, webDriverFactory).withOptions(options);
        }
        return new WebDriverFacade(driverClass, webDriverFactory).withOptions(options);
    }

    public WebDriverFacade proxyFor(WebDriver driver) {
        if (driver instanceof HasDevTools) {
            return new DevToolsWebDriverFacade(driver, this.webDriverFactory);
        }
        return new WebDriverFacade(driver, this.webDriverFactory);
    }

    public void registerListener(ThucydidesWebDriverEventListener eventListener) {
        eventListeners.add(eventListener);
    }

    public void notifyListenersOfWebdriverCreationIn(WebDriverFacade webDriverFacade) {
        for (ThucydidesWebDriverEventListener listener : WebdriverProxyFactory.getEventListeners()) {
            listener.driverCreatedIn(webDriverFacade);
        }
    }

    public WebDriver proxyDriver() {
        Class<? extends WebDriver> driverClass = this.webDriverFactory.getClassFor(this.configuration.getDriverType());
        return this.proxyFor(driverClass, this.webDriverFactory, ConfiguredEnvironment.getConfiguration());
    }

    public static void resetDriver(WebDriver driver) {
        if (driver instanceof WebDriverFacade) {
            ((WebDriverFacade)driver).reset();
        }
    }

    public void useMockDriver(WebDriverFacade mockDriver) {
        this.mockDriver = mockDriver;
    }

    public void clearMockDriver() {
        this.mockDriver = null;
    }

    public static void clearBrowserSession(WebDriver driver) {
        if (StepEventBus.getParallelEventBus().isDryRun()) {
            return;
        }
        if (driver instanceof WebDriverFacade && ((WebDriverFacade)driver).isInstantiated() && !((WebDriverFacade)driver).getProxiedDriver().getCurrentUrl().isEmpty()) {
            WebDriver proxiedDriver = ((WebDriverFacade)driver).getProxiedDriver();
            proxiedDriver.manage().deleteAllCookies();
            try {
                ((JavascriptExecutor)proxiedDriver).executeScript("window.sessionStorage.clear();", new Object[0]);
                ((JavascriptExecutor)proxiedDriver).executeScript("window.localStorage.clear();", new Object[0]);
            }
            catch (WebDriverException webDriverException) {
                // empty catch block
            }
        }
    }
}

