/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages.components;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class FileToDownload {
    private final URL url;

    public static FileToDownload fromUrl(URL url) {
        return new FileToDownload(url);
    }

    public FileToDownload(URL url) {
        this.url = url;
    }

    public byte[] asByteArray() throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byArray;
            try (BufferedInputStream in = new BufferedInputStream(this.url.openStream());){
                IOUtils.copy((InputStream)in, (OutputStream)out);
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }

    public String asString() throws IOException {
        return new String(this.asByteArray(), StandardCharsets.UTF_8);
    }
}

