/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.photography;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import net.serenitybdd.annotations.BlurLevel;

public class ScreenshotNegative {
    private final Path temporaryPath;
    private final Path screenshotPath;
    private final BlurLevel blurLevel;

    public ScreenshotNegative(Path temporaryPath, Path screenshotPath, BlurLevel blurLevel) {
        this.temporaryPath = temporaryPath;
        this.screenshotPath = screenshotPath;
        this.blurLevel = Optional.ofNullable(blurLevel).orElse(BlurLevel.NONE);
    }

    public Path getTemporaryPath() {
        return this.temporaryPath;
    }

    public Path getScreenshotPath() {
        return this.screenshotPath;
    }

    public BlurLevel getBlurLevel() {
        return this.blurLevel;
    }

    public static ScreenshotNegativeBuilder prepareNegativeIn(Path screenshotsDirectory) {
        return new ScreenshotNegativeBuilder(screenshotsDirectory);
    }

    public ScreenshotNegative withScreenshotPath(Path path) {
        return new ScreenshotNegative(this.temporaryPath, path, this.blurLevel);
    }

    public static class ScreenshotNegativeBuilder {
        private final Path screenshotsDirectory;
        private byte[] screenshotData;
        private BlurLevel blurLevel = BlurLevel.NONE;

        public ScreenshotNegativeBuilder(Path screenshotsDirectory) {
            this.screenshotsDirectory = screenshotsDirectory;
        }

        public ScreenshotNegativeBuilder withScreenshotData(byte[] screenshotData) {
            this.screenshotData = screenshotData;
            return this;
        }

        public ScreenshotNegative andTargetPathOf(Path finalScreenshotPath) throws IOException {
            Files.createDirectories(this.screenshotsDirectory, new FileAttribute[0]);
            Path screenshotWorkingFile = Files.createTempFile(this.screenshotsDirectory, "screenshot-", "", new FileAttribute[0]);
            Files.write(screenshotWorkingFile, this.screenshotData, new OpenOption[0]);
            return new ScreenshotNegative(screenshotWorkingFile, finalScreenshotPath, this.blurLevel);
        }

        public ScreenshotNegativeBuilder andBlurringOf(BlurLevel blurLevel) {
            this.blurLevel = blurLevel;
            return this;
        }
    }
}

